<?php
defined('BASEPATH') OR exit('No direct script access allowed');
// Including Phil Sturgeon's Rest Server Library in our Server file.

require APPPATH . '/libraries/REST_Controller.php';

class Api extends REST_Controller{
// Load model in constructor
public function __construct() {
    parent::__construct();
$this->load->database();
//Allowed API Headers
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
    header("Access-Control-Allow-Methods: POST");
    header("Allow: POST, OPTIONS, PUT, DELETE");
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");
      
    
}
public function user_POST()
 {
     $udetails = $this->authentication();
     $response['status']=true;
    $response['data'] = $udetails;
    $response['msg']= 'Welcome back, '.$udetails['fullname'];
    $response['Status']=ucwords($status);
    header('HTTP/1.0 200 Success');
    echo json_encode($response);
    exit;
     
 }
 public function checktransactionStatus_GET()
 {
     $getReference = $_GET['reference'];
     $details = $this->db->get_where('transactions', array('order_id' => $getReference));
     
     if($details->num_rows() > 0)
     {
         $row = $details->row_array();
         if($row['status'] == '1'){
         $response['status']="success";
         $response['msg']=$row['message'];
        $response['Status']="successful";
        header('HTTP/1.0 200 Transaction Successful');
        echo json_encode($response);
        exit;
     }else{
         $response['status']="fail";
        $response['msg']=$row['message'];
        $response['Status']="failed";
         header('HTTP/1.0 200 Transaction failed');
        echo json_encode($response);
        exit;
     }
         
     }else{
          header('HTTP/1.0 401 Unauthorized');
        // tell the user no products found
        $response["status"] = "fail";
        $response["msg"] = "Transaction failed";
        echo json_encode($response); exit();
     }
 }
 public function doResponse($status,$msg,$title,$data='')
{
        $response['status']=$status;
        $response['msg']= $msg;
        if($data !=''){
        $response['data']=$data;
        }
        header('HTTP/1.0 200 '.$title);
        echo json_encode($response);
        exit;
}
 public function getdatatype_GET()
 {
     if((isset($_GET['network']))&&(!empty($_GET['network'])))
         {
             $networkID = $_GET['network'];
            $result = $this->User_model->sub_module($id='2',$networkID); 
            foreach($result->result_array() as $list){
              $postData[] = $list;
            }
            $this->doResponse($status='success',$msg='Data Types',$title="",$data=$postData);
         }else{
             $this->doResponse($status='fail',$msg='Please select a network',$title="Failed");
         }
 }
    public function authentication()
    {
        $requestMethod = $_SERVER["REQUEST_METHOD"]; 
        $headers = apache_request_headers();
    if ($requestMethod !== 'POST') {
        header('HTTP/1.0 400 Bad Request');
        $response["status"] = "fail";
        $response["msg"] = "Only POST method is allowed";
        echo json_encode($response); exit(); 
    }
     if((isset($headers['Authorization']) || isset($headers['authorization'])) || (isset($headers['Token']) || isset($headers['token']))){
        
        if((isset($headers['Authorization']) || isset($headers['authorization']))){
            $token = trim(str_replace("Token", "", (isset($headers['Authorization'])) ? $headers['Authorization'] : $headers['authorization']));
        }
        if((isset($headers['Token']) || isset($headers['Token']))){
            $token = trim(str_replace("Token", "", (isset($headers['Token'])) ? $headers['Token'] : $headers['token']));
        }
        $result=$this->User_model->validateAccessToken($token);
        if($result == false){
            // tell the user no products found
            header('HTTP/1.0 401 Unauthorized');
            $response["status"] = "fail";
            $response["msg"] = "Authorization token not found $token";
            $response["api_response"] = "Authorization token not found $token";
            echo json_encode($response); exit(); 
        }
        else{
            if($result['suspend'] == '1')
              {
                 $response["status"] = "fail";
                $response["msg"] = "Please contact support";
                $response["api_response"] = "Please contact support";
                echo json_encode($response); exit();
                exit;
              }
            return $result;
         }
    }
    else{
        header('HTTP/1.0 401 Unauthorized');
        // tell the user no products found
        $response["status"] = "fail";
        $response["msg"] = "Your authorization token is required.";
        echo json_encode($response); exit(); 
    }
}
public function cashWithdraw_POST()
{
    $udetails = $this->authentication();
    $input = @file_get_contents("php://input");
    $body = json_decode($input);
    $bank= (isset($body->bank)) ? $body->bank : "";
    $accountNumber= (isset($body->accountNumber)) ? $body->accountNumber : "";
    $amount= (isset($body->amount)) ? $body->amount : "";
    $ref= (isset($body->ref)) ? $body->ref : "";
    if($bank == ""){$requiredField ="Bank Is Required"; }
    if($accountNumber == ""){$requiredField ="Account Number Is Required"; }
    if($ref == ""){$requiredField ="Ref ID Is Required"; }
    if($amount == ""){$requiredField ="Amount ID Is Required"; }
     
    if($requiredField != ""){
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = $requiredField;
        echo json_encode($response);
        exit;
     }
     if($this->User_model->get_module('13') == false)
     {
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = "Service is disabled. Please check back later";
        echo json_encode($response);
        exit;
    }
     $prevBalance = $udetails['wallet_balance'];
      $charge = ($amount + get_settings('withdrawFee'));
     if($udetails['wallet_balance'] >= $charge){
          $sendRequest = $this->Apiselector->inistiateTransfer($bank,$accountNumber,$ref,$amount,$prevBalance);
          if($sendRequest != false){
         $response['status']="success";
         $response['msg']="Request submitted successfully";
        $response['Status']="successful";
        $response['id']= '';//$save_order;
        header('HTTP/1.0 200 Transaction Successful');
        echo json_encode($response);
        exit;
          }else{
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = "unknown error occured";
        echo json_encode($response);
        exit;
          }
     }else{
         header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = "Insufficient wallet balance";
        echo json_encode($response);
        exit;
     }
     
    
}
public function verifyNin_POST()
{
    $udetails = $this->authentication();
$input = @file_get_contents("php://input");
$body = json_decode($input);    
$sliptype = (isset($body->sliptype)) ? $body->sliptype : "";
$ninNumber= (isset($body->ninNumber)) ? $body->ninNumber : "";
$ref= (isset($body->ref)) ? $body->ref : "";
if($sliptype == ""){$requiredField ="Slip Type Is Required"; }
if($ninNumber == ""){$requiredField ="NIN Number Is Required"; }
if($ref == ""){$ref = $this->uniqueid(); }
if($requiredField != ""){
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = $requiredField;
        echo json_encode($response);
        exit;
     }
    if($this->User_model->get_module('21') == false){
          header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = "Service is disabled. Please check back later";
        echo json_encode($response);
        exit;
      }  
    $module_id = '21';
$description = 'NIN Verification';
$subModule = $this->User_model->sub_module($module_id,$sliptype)->row_array(); 
$apiRoute = $subModule['api'];
$return_user_price =$this->User_model->get_user_package($udetails['accountid']);
$price = $subModule[$return_user_price];
if($price > $udetails['wallet_balance'] || $price < 0){
            header('HTTP/1.0 400 Insufficient Balance');
            $response['status']="fail";
            $response['reference'] = $ref;
            $response['msg'] = "Insufficient balance fund your wallet and try again";
            echo json_encode($response);
            exit;
    }
$userid = $udetails['accountid'];
$do_balance = $this->User_model->do_balance($udetails['accountid'],$price);
    if($do_balance){
     $save_order = $this->User_model->insert_transaction($udetails['accountid'],$description,$module_id,$sliptype,$price,$subModule['name'],$price,$apiRoute,$ref,$subModule['id'],$subModule['api_code']);
      $response = $this->Apiselector->send_transaction($save_order); 
        $response['status']="success";
        $response['msg']="Transaction successful";
         $response['reference'] = $ref;
        $response['Status']="successful";
        $response['id']=$save_order;
        header('HTTP/1.0 200 Transaction Successful');
        echo json_encode($response);
        exit;
     }else{
          header('HTTP/1.0 400 Transaction Failed');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['Status']="failed";
        $response['msg'] = "fail";
        echo json_encode($response);
        exit;
     }
}
public function cac_POST()
{
$udetails = $this->authentication();
$input = @file_get_contents("php://input");
$body = json_decode($input);    
$certtype = (isset($body->certtype)) ? $body->certtype : "";
$businessname1= (isset($body->businessname1)) ? $body->businessname1 : "";
$businessname2= (isset($body->businessname2)) ? $body->businessname2 : "";
$companyaddress= (isset($body->companyaddress)) ? $body->companyaddress : "";
$residentialaddress= (isset($body->residentialaddress)) ? $body->residentialaddress : "";
$businessnature= (isset($body->businessnature)) ? $body->businessnature : "";
$sharecapital= (isset($body->sharecapital)) ? $body->sharecapital : "";
$directorid= (isset($body->directorid)) ? $body->directorid : "";
$passport= (isset($body->passport)) ? $body->passport : "";
$signature= (isset($body->signature)) ? $body->signature : "";
$phone= (isset($body->phone)) ? $body->phone : "";
$email= (isset($body->email)) ? $body->email : "";
$ref= (isset($body->ref)) ? $body->ref : "";
if($businessname1 == ""){$requiredField ="Business Name Is Required"; }
if($companyaddress == ""){$requiredField ="Company Address Is Required"; }
if($residentialaddress == ""){$requiredField ="Residential Address Is Required"; }
if($businessnature == ""){$requiredField ="Business nature Address Is Required"; }
if($ref == ""){$ref = $this->uniqueid(); }
if($requiredField != ""){
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = $requiredField;
        echo json_encode($response);
        exit;
     }
 if($this->User_model->get_module('20') == false){
          header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = "Service is disabled. Please check back later";
        echo json_encode($response);
        exit;
      } 
    /*
    if($directorid != "") {
    $temp = explode(".", $_FILES[$body->directorid]["name"]);
    $newfilename = round(microtime(true)) . '.' . end($temp);
    $directoridpath = 'assets/images/cacreg/'.$newfilename;
    move_uploaded_file($_FILES['payment_proof']['tmp_name'],'assets/uploads/payment_proof/'.$newfilename);
    }
    */
    
$module_id = '20';
$description = 'CAC Registration';
$subModule = $this->User_model->sub_module($module_id,$certtype)->row_array(); 
$apiRoute = $subModule['api'];
$return_user_price =$this->User_model->get_user_package($udetails['accountid']);
$price = $subModule[$return_user_price];
if($price > $udetails['wallet_balance'] || $price < 0){
            header('HTTP/1.0 400 Insufficient Balance');
            $response['status']="fail";
            $response['reference'] = $ref;
            $response['msg'] = "Insufficient balance fund your wallet and try again";
            echo json_encode($response);
            exit;
    }
$userid = $udetails['accountid'];
$do_balance = $this->User_model->do_balance($udetails['accountid'],$price);
    if($do_balance){
     $save_order = $this->User_model->insert_transaction($udetails['accountid'],$description,$module_id,$certtype,$price,$subModule['name'],$price,$apiRoute,$ref,$subModule['id'],$subModule['api_code']);
      $response = $this->Apiselector->send_cactransaction($save_order,$certtype,$businessname1,$businessname2,$companyaddress,$residentialaddress,$businessnature,$sharecapital,$directorid,$passport,$signature,$phone,$email,$userid); 
        $response['status']="success";
        $response['msg']="Your CAC certificate will be ready in 3 to 14 days. The process will be sent to your email.	";
         $response['reference'] = $ref;
        $response['Status']="successful";
        $response['id']=$save_order;
        header('HTTP/1.0 200 Transaction Successful');
        echo json_encode($response);
        exit;
     }else{
          header('HTTP/1.0 400 Transaction Failed');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['Status']="failed";
        $response['msg'] = "fail";
        echo json_encode($response);
        exit;
     }
    
}
public function airtimeCashOTP_POST()
{
    $udetails = $this->authentication();
    $input = @file_get_contents("php://input");
    $body = json_decode($input);
    $network= (isset($body->network)) ? $body->network : "";
    $phone= (isset($body->phone)) ? $body->phone : "";
    $amount= (isset($body->amount)) ? $body->amount : "";
    $ref= (isset($body->ref)) ? $body->ref : "";
    if($network == ""){$requiredField ="Provider Is Required"; }
    if($phone == ""){$requiredField ="Phone Number Is Required"; }
    if($ref == ""){$requiredField ="Ref ID Is Required"; }
    if($requiredField != ""){
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = $requiredField;
        echo json_encode($response);
        exit;
     }
     if($this->User_model->get_module('7') == false){
          header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = "Service is disabled. Please check back later";
        echo json_encode($response);
        exit;
      }
      
      $getOTP = $this->Apiselector->getOTPAtoC($network,$phone,$ref);
      if($getOTP !=false){
          $this->saveDetailsAirtimCash($udetails,$network,$phone,$ref,$getOTP['message'],$amount);
          header('HTTP/1.0 200 Parameters Required');
         $response['status']="success";
        $response['msg'] = $getOTP['message'];
        $response['ref'] = $ref;
        echo json_encode($response);
        exit;
      }else{
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = "Service is disabled. Please check back later";
        //$response['msg'] = $getOTP;
        echo json_encode($response);
        exit;
      }
         
}
public function saveDetailsAirtimCash($udetails,$network,$phone,$ref,$response,$amount)
{
    $data['user_id'] = $udetails['accountid'];
    $data['network'] = $network;
    $data['phone'] = $phone;
    $data['amount'] = $amount;
    $data['date_added'] = date('Y-m-d H:i:s');
  //  $data['identifier'] = $response;
  //  $data['otp'] = $response['otp'];
    $data['reference'] = $ref;
    $this->db->insert('airtimeConverter',$data);
    return true;
}
public function airtimeCash_POST()
{
    $udetails = $this->authentication();
    $input = @file_get_contents("php://input");
    $body = json_decode($input);
    $otp = (isset($body->otp)) ? $body->otp : "";
    $network = (isset($body->network)) ? $body->network : "";
    $sendingNumber = (isset($body->sendingNumber)) ? $body->sendingNumber : "";
    $amount = (isset($body->amount)) ? $body->amount : "";
    $ref = (isset($body->ref)) ? $body->ref : "";
    $pin = (isset($body->pin)) ? $body->pin : "";
    $identifier = (isset($body->identifier)) ? $body->identifier : "";
      if($network == ""){$requiredField ="Network Is Required"; }
    if($otp == ""){$requiredField ="OTP Is Required"; }
    if($sendingNumber == ""){$requiredField ="Sending Number Is Required"; }
    if($ref == ""){$requiredField ="Ref ID Is Required"; }
    if($amount == ""){$requiredField ="Amount Is Required"; }
    if($pin == ""){$requiredField ="Transfer PIN Is Required"; }
    if($identifier == ""){$requiredField ="Ident Ref PIN Is Required"; }
    if($requiredField != ""){
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = $requiredField;
        echo json_encode($response);
        exit;
     }
      if($this->User_model->get_module('7') == false){
          header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = "Service is disabled. Please check back later";
        echo json_encode($response);
        exit;
      }
      
      $verifyOTP = $this->Apiselector->sendOTPAtoC($network,$otp,$identifier);
    if($verifyOTP !=false){
    $this->sendAirtimeC($udetails,$identifier,$verifyOTP,$pin,$ref);
          header('HTTP/1.0 200 Parameters Required');
         $response['status']="success";
        $response['msg'] = $verifyOTP['message'];
        echo json_encode($response);
        exit;
      }else{
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = "Service is disabled. Please check back later";
        echo json_encode($response);
        exit;
      }
         
}
public function sendAirtimeC($udetails,$identifier,$verifyOTP,$pin,$ref)
{
    
    $data['user_id'] = $udetails['accountid'];
    $data['message'] = $verifyOTP['message'];
    $data['airtimeBalance'] = $verifyOTP['data']['airtimeBalance'];
    $data['tariffPlan'] =  $verifyOTP['data']['type'];
    $data['tariffType'] =  $verifyOTP['data']['tariff'];
    $data['sessionId'] = $verifyOTP['data']['sessionId'];
    $data['authPIN'] = $pin;
    $this->db->where('reference',$identifier);
    $this->db->update('airtimeConverter',$data);
    $details = $this->db->get_where('airtimeConverter',array('reference' => $identifier))->row_array();
    $response = $this->Apiselector->sendAirtimCash($details);
    $dataU['api_response'] = json_encode($response);
    $this->db->where('reference',$identifier);
    $this->db->update('airtimeConverter',$dataU);
    return true;
}
public function exampin_POST()
{
    $udetails = $this->authentication();
    $input = @file_get_contents("php://input");
    $body = json_decode($input);
    $module = '8';
    $requiredField = "";
    $examid= (isset($body->examid)) ? $body->examid : "";
    $quantity= (isset($body->quantity)) ? $body->quantity : "";
   $ref= (isset($body->ref)) ? $body->ref : "";
    if($examid == ""){$requiredField ="Exam ID Is Required"; }
    if($quantity == ""){$requiredField ="Quantity Is Required"; }
    if($ref == ""){$requiredField ="Ref ID Is Required"; }
    if($requiredField != ""){
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = $requiredField;
        echo json_encode($response);
        exit;
     }
     $price = $this->User_model->calculate_exampin_price($udetails['accountid'],$examid,$quantity);
     if($price > $udetails['wallet_balance'] || $price < 0){
            header('HTTP/1.0 400 Insufficient Balance');
            $response['status']="fail";
            $response['msg'] = "Insufficient balance fund your wallet and try again";
            echo json_encode($response);
            exit;
    }
    if($this->User_model->checkiforderidExist($ref)->num_rows() > 0)
    {
        header('HTTP/1.0 400 Transaction Ref Already Exist');
        $response['status']="fail";
        $response['msg'] = "Transaction Ref Already Exist";
        echo json_encode($response);
        exit;
    }
    
    $description = 'Exam PIN Purchase';
    $subModule = $this->User_model->get_submodule_single('8',$examid)->row_array();
    if($subModule['status'] == '0')
    {
         header('HTTP/1.0 400 Product not available. Please try again later');
        $response['status']="fail";
        $response['msg'] = "Product not available. Please try again later";
        echo json_encode($response);
        exit;
    }
    $do_balance = $this->User_model->do_balance($udetails['accountid'],$price);
    if($do_balance){
        $apiRoute = $subModule['api'];
        $date_schedued = date('Y-m-d H:i:s');
        $date_created = date('Y-m-d');
         $save_order = $this->User_model->insert_transaction($udetails['accountid'],$description,$module,$examid,$quantity,$subModule['name'],$price,$apiRoute,$ref,$subModule['id'],$subModule['api_code']);
         $response = $this->Apiselector->send_transaction($save_order);
         $response['status']="success";
         $response['msg']="Transaction Successful";
        $response['Status']="successful";
        $response['id']=$save_order;
        header('HTTP/1.0 200 Transaction Successful');
        echo json_encode($response);
        exit;
     }else{
          header('HTTP/1.0 400 Transaction Failed');
        $response['status']="fail";
        $response['Status']="failed";
        $response['msg'] = "fail";
        echo json_encode($response);
        exit;
     }
     
}
public function buyElectricity_POST()
{
    $udetails = $this->authentication();
    $input = @file_get_contents("php://input");
    $body = json_decode($input);
    $module = '4';
    $requiredField = "";
    $provider= (isset($body->provider)) ? $body->provider : "";
    $meternumber = (isset($body->meternumber)) ? $body->meternumber : "";
    $metertype = (isset($body->metertype)) ? $body->metertype : "";
    $ref = (isset($body->ref)) ? $body->ref : "";
    $amount = (isset($body->amount)) ? $body->amount : "";
    if($provider == ""){$requiredField ="Provider Is Required"; }
    if($meternumber == ""){$requiredField ="Meter Number Is Required"; }
    if($metertype == ""){$requiredField ="Meter Type Is Required"; }
    if($ref == ""){$requiredField ="Ref ID Is Required"; }
    if($amount == ""){$requiredField ="Amount Is Required"; }
    if($requiredField != ""){
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = $requiredField;
        echo json_encode($response);
        exit;
     }
     $subModule = $this->User_model->verifyElectifictyStatus($module);
     $planDetails = getElectricityProvider($provider);
     if(($planDetails->num_rows() < 1) || ($subModule->num_rows() < 1))
     {
         header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "Electricity provider is not available at this time";
        echo json_encode($response);
        exit;
     }
     $planRow = $planDetails->row_array();
     $submoduleRow = $subModule->row_array();
     $price = $this->User_model->calculate_electricityPrice($udetails['accountid'],$amount,$submoduleRow,$provider);
     if($price > $udetails['wallet_balance'] || $price < 0){
            header('HTTP/1.0 400 Insufficient Balance');
            $response['status']="fail";
            $response['reference'] = $ref;
            $response['msg'] = "Insufficient balance fund your wallet and try again";
            echo json_encode($response);
            exit;
    }
    
    $electricitymin = (int) get_settings('electricitymin');
    $electricitymax = (int) get_settings('electricitymax');
    
    if($amount < $electricitymin){
        header("HTTP/1.0 400 Minimum Electricity purchase is $electricitymin");
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "Minimum Electricity you can purchase is $electricitymin";
        echo json_encode($response);
        exit;
    }

    if($amount > $electricitymax){
        header("HTTP/1.0 400 Maximum Electricity purchase is $electricitymax");
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "Maximum Electricity you can purchase is $electricitymax";
        echo json_encode($response);
        exit;
    }
    
    if($this->User_model->checkiforderidExist($ref)->num_rows() > 0)
    {
        header('HTTP/1.0 400 Transaction Ref Already Exist');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "Transaction Ref Already Exist";
        echo json_encode($response);
        exit;
    }
    if($this->User_model->checkforTimeInterval($meternumber) == false)
    {
        header('HTTP/1.0 400 Duplication of Transaction');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "Meter Number ('.$meternumber.') Duplicate transaction. Please try again after 1 minute";
        echo json_encode($response);
        exit;
    }
     $checkLimit = $this->User_model->checkDailyLimit($udetails['accountid'],$price);
          if($checkLimit == false)
          {
        header('HTTP/1.0 400 Duplication of Transaction');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "You Have reached your spending limit for today. Kindly message customer care to increase Your Daily limit or wait till tommorow to enable you perform another transaction";
        echo json_encode($response);
        exit;
        
          }
     $description = $planRow['name']. ' payment of '.$amount.' for meter number '.$meternumber;
    $do_balance = $this->User_model->do_balance($udetails['accountid'],$price);
     if($do_balance){
        $apiRoute = $submoduleRow['api'];
          $save_order = $this->User_model->insert_transaction($udetails['accountid'],$description,$module,$provider,$meternumber,$planRow['name'],$price,$apiRoute,$ref,$submoduleRow['id'],$amount);
        $response = $this->Apiselector->send_transaction($save_order);
         $response['status']="success";
         $response['msg']="Transaction Successful";
         $response['reference'] = $ref;
        $response['Status']="successful";
        $response['id']=$save_order;
        header('HTTP/1.0 200 Transaction Successful');
        echo json_encode($response);
        exit;
     }else{
          header('HTTP/1.0 400 Transaction Failed');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['Status']="failed";
        $response['msg'] = "fail";
        echo json_encode($response);
        exit;
     }
     
}
public function purchaseTV_POST()
{
    $udetails = $this->authentication();
    $input = @file_get_contents("php://input");
    $body = json_decode($input);
    $module = '3';
    $requiredField = "";
    $provider= (isset($body->provider)) ? $body->provider : "";
    $iucnumber= (isset($body->iucnumber)) ? $body->iucnumber : "";
    $plan= (isset($body->plan)) ? $body->plan : "";
    $ref= (isset($body->ref)) ? $body->ref : "";
    if($provider == ""){$requiredField ="Provider Is Required"; }
    if($iucnumber == ""){$requiredField ="IUC Number Is Required"; }
    if($plan == ""){$requiredField ="Plan ID Is Required"; }
    if($ref == ""){$requiredField ="Ref ID Is Required"; }
    if($requiredField != ""){
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = $requiredField;
        echo json_encode($response);
        exit;
     }
     $verifyNetwork = $this->User_model->verifyNetworkId($module,$provider);
     $subModule = $this->User_model->sub_module_tv($module,$provider);
     $planDetails = $this->User_model->getTVPlanbyID($plan);
     if($planDetails->num_rows() < 1)
     {
         header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "TV Plan is not available at this time";
        echo json_encode($response);
        exit;
     }
     $planRow = $planDetails->row_array();
     $price = $this->User_model->calculate_tv_price($udetails['accountid'],$planRow['id'],$provider);
     if($price > $udetails['wallet_balance'] || $price < 0){
            header('HTTP/1.0 400 Insufficient Balance');
            $response['status']="fail";
            $response['reference'] = $ref;
            $response['msg'] = "Insufficient balance fund your wallet and try again";
            echo json_encode($response);
            exit;
    }
    
    if($this->User_model->checkiforderidExist($ref)->num_rows() > 0)
    {
        header('HTTP/1.0 400 Transaction Ref Already Exist');
        $response['status']="fail";
        $response['msg'] = "Transaction Ref Already Exist";
        echo json_encode($response);
        exit;
    }
     $checkLimit = $this->User_model->checkDailyLimit($udetails['accountid'],$price);
          if($checkLimit == false)
          {
        header('HTTP/1.0 400 Duplication of Transaction');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "You Have reached your spending limit for today. Kindly message customer care to increase Your Daily limit or wait till tommorow to enable you perform another transaction";
        echo json_encode($response);
        exit;
        }
     $description = $planRow['package_name']. ' subscription for IUC '.$iucnumber;
    $do_balance = $this->User_model->do_balance($udetails['accountid'],$price);
     if($do_balance){
        $apiRoute = $subModule['api'];
          $save_order = $this->User_model->insert_transaction($udetails['accountid'],$description,$module,$provider,$iucnumber,$planRow['package_name'],$price,$apiRoute,$ref,$subModule['id'],$plan);
        $prevBalance =  $udetails['wallet_balance'];
        $this->User_model->updateBalances($save_order,$prevBalance);
        $response = $this->Apiselector->send_transaction($save_order);
         $response['status']="success";
         $response['reference'] = $ref;
         $response['msg']="Transaction Successful";
        $response['Status']="successful";
        $response['id']=$save_order;
        header('HTTP/1.0 200 Transaction Successful');
        echo json_encode($response);
        exit;
     }else{
          header('HTTP/1.0 400 Transaction Failed');
        $response['status']="fail";
        $response['Status']="failed";
        $response['reference'] = $ref;
        $response['msg'] = "fail";
        echo json_encode($response);
        exit;
     }
     
    
}
public function verifyMeter_POST()
{
    $udetails = $this->authentication();
    $input = @file_get_contents("php://input");
    $body = json_decode($input);
    $module = '4';
    $requiredField = "";
    $provider= (isset($body->provider)) ? $body->provider : "";
    $meternumber = (isset($body->meternumber)) ? $body->meternumber : "";
    $metertype = (isset($body->metertype)) ? $body->metertype : "";
    if($provider == ""){$requiredField ="Provider Is Required"; }
    if($meternumber == ""){$requiredField ="Meter Number Is Required"; }
    if($metertype == ""){$requiredField ="Meter Type Is Required"; }
    if($requiredField != ""){
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = $requiredField;
        echo json_encode($response);
        exit;
     }
     $verifyNetwork = $this->User_model->verifyNetworkId($module,$provider);
     $subModule = $this->User_model->sub_module_Electricity($module,$provider);
      if($subModule['status'] == '0'){
        header('HTTP/1.0 400 Provider not available');
        $response['status']="fail";
        $response['msg'] = "Provider not available";
        echo json_encode($response);
        exit;
    }
    //do_verifyMeterMSorg($getApi,$subModule,$meternumber)
    //$provider,$meternumber,$subModule
        $result = $this->Apiselector->doVerifyMeter($provider,$meternumber,$subModule);
         $response['status']="success";
          $response['msg']= $result;
        $response['Status']="successful";
        header('HTTP/1.0 200 Transaction Successful');
        echo json_encode($response);
        exit;
    
    
}

public function verifytv_POST()
{
    $udetails = $this->authentication();
    $input = @file_get_contents("php://input");
    $body = json_decode($input);
    $module = '3';
    $requiredField = "";
    $provider= (isset($body->provider)) ? $body->provider : "";
    $iucnumber= (isset($body->iucnumber)) ? $body->iucnumber : "";
    if($provider == ""){$requiredField ="Provider Is Required"; }
    if($iucnumber == ""){$requiredField ="IUC Is Required"; }
    if($requiredField != ""){
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = $requiredField;
        echo json_encode($response);
        exit;
     }
     $verifyNetwork = $this->User_model->verifyNetworkId($module,$provider);
     $row = $verifyNetwork->row_array();
     $subModule = $this->User_model->sub_module_tv($module,$row['network_id']);
      if($verifyNetwork == false){
        header('HTTP/1.0 400 Invalid Provider Id');
        $response['status']="fail";
        $response['msg'] = "The Provider id is invalid";
        echo json_encode($response);
        exit;
    }
        $result = $this->Apiselector->verifyTV($provider,$iucnumber,$subModule);
         $response['status']="success";
          $response['msg']= $result;
        $response['Status']="successful";
        header('HTTP/1.0 200 Transaction Successful');
        echo json_encode($response);
        exit;
    
    
}
    public function airtime_POST()
    {
    $udetails = $this->authentication();
    $input = @file_get_contents("php://input");
    $body = json_decode($input);
    $network= (isset($body->network)) ? $body->network : "";
    $phone= (isset($body->phone)) ? $body->phone : "";
    $amount= (isset($body->amount)) ? $body->amount : "";
    $ported_number= (isset($body->ported_number)) ? $body->ported_number : "false";
    $airtime_type= (isset($body->airtime_type)) ? $body->airtime_type : "1";
    $ref= (isset($body->ref)) ? $body->ref : "";
    
    $requiredField = "";
    $module = '1';
    if($airtime_type == ""){$requiredField ="Airtime Type Is Required"; }
    if($amount == ""){$requiredField ="Amount Is Required"; }
    if($phone == ""){$requiredField ="Phone Is Required"; }
    if($network == ""){$requiredField ="Network Id Required"; }
    if($ref == ""){$requiredField ="Ref Is Required"; }
    
    if($requiredField != ""){
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = $requiredField;
        echo json_encode($response);
        exit;
     }
     
     if($amount < 1)
     {
         header('HTTP/1.0 400 Invalid Network Id');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "Invalid amount";
        echo json_encode($response);
        exit;
     }
     $verifyNetwork = $this->User_model->verifyNetworkId($module,$network);
     $subModule = $this->User_model->sub_module_single($airtime_type);
      if($verifyNetwork == false){
        header('HTTP/1.0 400 Invalid Network Id');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "The Network id is invalid";
        echo json_encode($response);
        exit;
    }
    if($subModule == false){
        header('HTTP/1.0 400 Airtime type not available');
        $response['status']="fail";
        $response['msg'] = "The Airtime Type is not available on this network";
        echo json_encode($response);
        exit;
    }
    $phone = removeSpaces($phone);
    $NetworkResult = $verifyNetwork->row_array();
    if($ported_number == "false"){
        $VerifyNresult = verifyPhoneNumber($phone,$NetworkResult["network_id"]);
        if($VerifyNresult["status"]=="fail"){
            header('HTTP/1.0 400 Invalid Phone Number');
            $response['status']="fail";
            $response['reference'] = $ref;
            $response['msg'] = $VerifyNresult["msg"];
            echo json_encode($response);
            exit;
        }
    }
    $price = $this->User_model->calculate_airtime_price($udetails['accountid'],$amount,$network);
     if($price > $udetails['wallet_balance'] || $price < 0){
            header('HTTP/1.0 400 Insufficient Balance');
            $response['status']="fail";
            $response['reference'] = $ref;
            $response['msg'] = "Insufficient balance fund your wallet and try again";
            echo json_encode($response);
            exit;
    }
    $airtimemin = (int) get_settings('airtimemin');
    $airtimemax = (int) get_settings('airtimemax');
    
    if($amount < $airtimemin){
        header("HTTP/1.0 400 Minimum airtime purchase is $airtimemin");
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "Minimum airtime you can purchase is $airtimemin";
        echo json_encode($response);
        exit;
    }

    if($amount > $airtimemax){
        header("HTTP/1.0 400 Maximum airtime purchase is $airtimemax");
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "Maximum airtime you can purchase is $airtimemax";
        echo json_encode($response);
        exit;
    }
    
    if($this->User_model->checkiforderidExist($ref)->num_rows() > 0)
    {
        header('HTTP/1.0 400 Transaction Ref Already Exist');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "Transaction Ref Already Exist";
        echo json_encode($response);
        exit;
    }
    if($this->User_model->checkforTimeInterval($phone) == false)
    {
        header('HTTP/1.0 400 Duplication of Transaction');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "Phone Number ('.$phone.') Duplicate transaction. Please try again after 1 minute";
        echo json_encode($response);
        exit;
    }
    $checkLimit = $this->User_model->checkDailyLimit($udetails['accountid'],$price);
          if($checkLimit == false)
          {
        header('HTTP/1.0 400 Duplication of Transaction');
        $response['status']="fail";
        $response['msg'] = "You Have reached your spending limit for today. Kindly message customer care to increase Your Daily limit or wait till tommorow to enable you perform another transaction";
        echo json_encode($response);
        exit;
        
          }
    $description = $NetworkResult['network_name']. ' Airtime purchase of ₦'.$amount.' for phone number '.$phone;
    $do_balance = $this->User_model->do_balance($udetails['accountid'],$price);
     if($do_balance){
        $apiRoute = $subModule['api'];
          $save_order = $this->User_model->insert_transaction($udetails['accountid'],$description,$module,$network,$phone,$amount,$price,$apiRoute,$ref,$subModule['id']);
        $data_queue['checkReversal'] =  '1';$this->db->where('id',$save_order);$this->db->update('transactions',$data_queue);
        $prevBalance =  $udetails['wallet_balance'];
        $this->User_model->updateBalances($save_order,$prevBalance);
        $response = $this->Apiselector->send_transaction($save_order);
        $checkStatus = $this->User_model->get_transaction_id($save_order)->row_array(); 
     if($checkStatus['status'] == '1'){
         $this->User_model->doRefBonus($subModule['ref_bonus'],$udetails['accountid'],$price,$ref);
         $response['status']="success";
         $response['msg']="Airtime sent successfully";
        $response['Status']="successful";
        $response['id']=$save_order;
        $response['reference'] = $checkStatus['order_id'];
        $response['api_response'] = '';
        header('HTTP/1.0 200 Transaction Successful');
        echo json_encode($response);
        exit;
         }else{
       //$this->reverse($save_order);  
        header('HTTP/1.0 400 Transaction Failed');
        $response['status']="fail";
        $response['Status']="failed";
        $response['api_response'] = "";
        $response['reference'] = $checkStatus['order_id'];
        $response['msg'] = $checkStatus['description'];
        echo json_encode($response);
        exit;
         }
     }else{
          header('HTTP/1.0 400 Transaction Failed');
        $response['status']="fail";
        $response['Status']="failed";
        $response['reference'] = $ref;
        $response['msg'] = "Insufficient balance fund your wallet and try again";
     }
     
    }
    
    public function dataplan_GET()
    {
       $network = $_GET['network'];
        $datatype = $_GET['datatype'];
        $result = $this->User_model->getPlanbyNetworkIDANDdataType($network,$datatype);
        if($result->num_rows() > 0){
        foreach($result->result_array() as $list){
              $postData[] = $list;
            }
        $response['status']="success";
        $response['data']= $postData;
        $response['reference'] = ''; //$checkStatus['order_id'];
        header('HTTP/1.0 200 Transaction Successful');
        echo json_encode($response);
        exit; 
    }else{
        $response['status']="fail";
        header('HTTP/1.0 404 Transaction Successful');
        echo json_encode($response);
        exit; 
    }
    
}    
     public function uniqueid()
  {
    $un = substr(number_format(time() * rand(),0,'',''),0,12);
    return 'APP'.$un;
  }
    
    
    public function data_POST()
    {
    $udetails = $this->authentication();
    $input = @file_get_contents("php://input");
    $body = json_decode($input);
    $network= (isset($body->network)) ? $body->network : "";
    $phone= (isset($body->mobile_number)) ? $body->mobile_number : "";
    //$plan= (isset($body->plan)) ? $body->plan : "";
    $plan= (isset($body->plan)) ? $body->plan : "";
    $ported_number= (isset($body->ported_number)) ? $body->ported_number : "false";
    $ref= (isset($body->ref)) ? $body->ref : "";
    
    $requiredField = "";
    $module = '2';
    if($plan == ""){$requiredField ="Plan Is Required"; }
    if($phone == ""){$requiredField ="Phone Is Required"; }
    if($network == ""){$requiredField ="Network is Required"; }
    if($ref == ""){$requiredField ="Ref Is Required"; }
    
    if($requiredField != ""){
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = $requiredField;
        $response['reference'] = $ref;
        echo json_encode($response);
        exit;
     }
     
     
     $verifyNetwork = $this->User_model->verifyNetworkId($module,$network);
     $verifyplanID = $this->User_model->verifyPlanID($plan);
     
      if($verifyNetwork == false){
        header('HTTP/1.0 400 Invalid Network Id');
        $response['status']="fail";
        $response['msg'] = "The Network id is invalid";
        $response['reference'] = $ref;
        echo json_encode($response);
        exit;
    }
    
    if($verifyplanID == false){
        header('HTTP/1.0 400 Plan ID not available');
        $response['status']="fail";
        $response['msg'] = "Data Plan is not available on this network";
        $response['reference'] = $ref;
        echo json_encode($response);
        exit;
    }
    
    $NetworkResult = $verifyNetwork->row_array();
    $planDetails = $verifyplanID->row_array();
    $subModule = $this->User_model->sub_module_single($planDetails['subtype']);
    if($subModule == false){
        header('HTTP/1.0 400 Data type not available');
        $response['status']="fail";
        $response['msg'] = "The Data Type is not available on this network";
        $response['reference'] = $ref;
        echo json_encode($response);
        exit;
    }
    $phone = removeSpaces($phone);
    if($ported_number == "false"){
        $VerifyNresult = verifyPhoneNumber($phone,$NetworkResult["network_id"]);
        if($VerifyNresult["status"]=="fail"){
            header('HTTP/1.0 400 Invalid Phone Number');
            $response['status']="fail";
            $response['msg'] = $VerifyNresult["msg"];
            $response['api_response'] = json_encode($response);
            $response['reference'] = $ref;
            echo json_encode($response);
            exit;
        }
    }
    $userType = $this->User_model->get_user_price($udetails['accountid']);
    
    $price = $planDetails[$userType];
   
     if($price > $udetails['wallet_balance'] || $price < 0){
            header('HTTP/1.0 400 Insufficient Balance');
            $response['status']="fail";
            $response['msg'] = "Insufficient balance fund your wallet and try again";
            $response['api_response'] = json_encode($response);
            $response['reference'] = $ref;
            echo json_encode($response);
            exit;
    }
    if($price =='')
    {
        header('HTTP/1.0 400 Insufficient Balance');
            $response['status']="fail";
            $response['msg'] = "Insufficient balance fund your wallet and try again";
            $response['api_response'] = json_encode($response);
            $response['reference'] = $ref;
            echo json_encode($response);
            exit;
    }
    if($this->User_model->checkiforderidExist($ref)->num_rows() > 0)
    {
        header('HTTP/1.0 400 Transaction Ref Already Exist');
        $response['status']="fail";
        $response['msg'] = "Transaction Ref Already Exist";
        $response['reference'] = $ref;
        echo json_encode($response);
        exit;
    }
    if($this->User_model->checkforTimeInterval($phone) == false)
    {
        header('HTTP/1.0 400 Duplication of Transaction');
        $response['status']="fail";
        $response['reference'] = $ref;
        $response['msg'] = "Phone Number ('.$phone.') Duplicate transaction. Please try again after 1 minute";
        echo json_encode($response);
        exit;
    }
     $checkLimit = $this->User_model->checkDailyLimit($udetails['accountid'],$price);
     /*     if($checkLimit == false)
          {
        header('HTTP/1.0 400 Duplication of Transaction');
        $response['status']="fail";
        $response['msg'] = "You Have reached your spending limit for today. Kindly message customer care to increase Your Daily limit or wait till tommorow to enable you perform another transaction";
        echo json_encode($response);
        exit;
        }
    */
    
    
     $description = $NetworkResult['network_name']. ' Data purchase of '.$planDetails['package_name'].' to phone number '.$phone;
    $do_balance = $this->User_model->do_balance($udetails['accountid'],$price);
     if($do_balance){
        $apiRoute = $subModule['api'];
        $profit = ($price - $planDetails['price']);
          $save_order = $this->User_model->insert_transaction($udetails['accountid'],$description,$module,$network,$phone,$planDetails['package_name'],$price,$apiRoute,$ref,$subModule['id'],$planDetails['provider_code']);
        $data_queue['checkReversal'] =  '1';$data_queue['profit'] = $profit;$this->db->where('id',$save_order);$this->db->update('transactions',$data_queue);
        $prevBalance =  $udetails['wallet_balance'];
        $this->User_model->updateBalances($save_order,$prevBalance);
        $apiResponse = $this->Apiselector->send_transaction($save_order);
         $checkStatus = $this->User_model->get_transaction_id($save_order)->row_array(); 
         if($checkStatus['status'] == '1'){
        $this->User_model->doRefBonus($subModule['ref_bonus'],$udetails['accountid'],$price,$ref);     
         $response['status']="success";
        $response['msg']="Data sent successfully";
        $response['reference']=$checkStatus['order_id'];
        $response['Status']="successful";
        $response['id']=$save_order;
        $response['api_response'] = json_encode($apiResponse);
        header('HTTP/1.0 200 Transaction Successful');
        echo json_encode($response);
        exit;
        
         }elseif($checkStatus['status'] == '0'){
        //$this->User_model->doRefBonus($subModule['ref_bonus'],$udetails['accountid'],$price,$ref);     
         $response['status']="success";
        $response['msg']="Order is processing...";
        $response['reference']=$checkStatus['order_id'];
        $response['Status']="successful";
        $response['id']=$save_order;
        $response['api_response'] = json_encode($apiResponse);
        header('HTTP/1.0 200 Transaction Successful');
        echo json_encode($response);
        exit;
         }else{
       //$this->reverse($save_order);  
        header('HTTP/1.0 400 Transaction Failed');
        $response['status']="fail";
        $response['Status']="failed";
        $response['api_response'] = "";
        $response['reference'] = $checkStatus['order_id'];
        $response['msg'] = $checkStatus['description'];
        echo json_encode($response);
        exit;
         }
     }else{
          header('HTTP/1.0 400 Transaction Failed');
        $response['status']="fail";
        $response['Status']="failed";
        $response['api_response'] = "";
        $response['reference'] = $ref;
        $response['msg'] = "Insufficient wallet balance";
        echo json_encode($response);
        exit;
     }
     
}
public function sendSMS_POST()
{
    $udetails = $this->authentication();
    $input = @file_get_contents("php://input");
    $body = json_decode($input);
    $module = '5';
    $requiredField = "";
    $sender= (isset($body->sender)) ? $body->sender : "";
    $recipients= (isset($body->recipients)) ? $body->recipients : "";
    $message= (isset($body->message)) ? $body->message : "";
    $ref= (isset($body->ref)) ? $body->ref : "";
    if($sender == ""){$requiredField ="Sender Is Required"; }
    if($recipients == ""){$requiredField ="Recipient Is Required"; }
    if($message == ""){$requiredField ="Message Is Required"; }
    if($ref == ""){$requiredField ="Ref ID Is Required"; }
    if($requiredField != ""){
        header('HTTP/1.0 400 Parameters Required');
        $response['status']="fail";
        $response['msg'] = $requiredField;
        echo json_encode($response);
        exit;
     }
        $numbers = countRecipient($recipients);
        $duplicate_removed = removeDuplicate($recipients);
        $pages = countPage($message);
        $price = $this->User_model->calculate_sms_price($udetails['accountid'],$numbers,$pages);
     if($price > $udetails['wallet_balance'] || $price < 0){
            header('HTTP/1.0 400 Insufficient Balance');
            $response['status']="fail";
            $response['msg'] = "Insufficient balance fund your wallet and try again";
            echo json_encode($response);
            exit;
    }
    
    if($this->User_model->checkiforderidExist($ref)->num_rows() > 0)
    {
        header('HTTP/1.0 400 Transaction Ref Already Exist');
        $response['status']="fail";
        $response['msg'] = "Transaction Ref Already Exist";
        echo json_encode($response);
        exit;
    }
     $description = 'Bulk SMS order';
    $do_balance = $this->User_model->do_balance($udetails['accountid'],$price);
    $subModule = $this->User_model->get_submodule_single('5','01')->row_array();
     if($do_balance){
        $apiRoute = $subModule['api'];
        $date_schedued = date('Y-m-d H:i:s');
        $date_created = date('Y-m-d');
        $saveID = $this->User_model->saveSMS($udetails['accountid'],$module='5',$ref,$price,$recipients,$message,$sender,$date_schedued,$date_created,$pages,$numbers);
         $save_order = $this->User_model->insert_transaction($udetails['accountid'],$description,$module='5',$provider="",$iucnumber="",$sender,$price,$apiRoute,$ref,$subModule['id'],$plan="");
         $response = $this->Apiselector->send_transaction($save_order);
         $response['status']="success";
         $response['msg']="Transaction Successful";
        $response['Status']="successful";
        $response['id']=$save_order;
        header('HTTP/1.0 200 Transaction Successful');
        echo json_encode($response);
        exit;
     }else{
          header('HTTP/1.0 400 Transaction Failed');
        $response['status']="fail";
        $response['Status']="failed";
        $response['msg'] = "fail";
        echo json_encode($response);
        exit;
     }
     
    
}
public function reverse($id)
{
        $getDetails = $this->db->get_where('transactions',array('id'=>$id))->row_array();
        if($getDetails['status'] == '6')
        {
            return false;
            exit;
        }
        $reversedCode = $this->db->get_where('status_code',array('value'=>'reversed'))->row_array();
        $userDetails = get_user_info($getDetails['user_id']);
        $newbal = ($userDetails['wallet_balance'] + $getDetails['charge']);
        $sub = 'Trasaction ID ('.$getDetails['order_id'].') Reversed';
        $body = 'Dear '.$userDetails['fullname'].', <br/><br/> This is to nofity you that transaction with reference ID: '.$getDetails['order_id'].' has just been reversed. See details below <br/><br/>
        Description: '.$getDetails['description'].' <br/> Beneficiary: '.$getDetails['recipient'].' <br/> Transaction Date: '.$getDetails['date_added'].'<br/> Reversed Date: '.date('Y-m-d').'<br/> Previous Balance: NGN '.$userDetails['wallet_balance'].' <br/>New Balance: '.$newbal.' <br/>Transaction Ref: '.$getDetails['order_id'].' <br/><br/>Regards<br/> '.get_settings('app_name').' Team';
     $this->User_model->do_CreditWallet($userDetails['accountid'],$getDetails['charge'],$wallet_type='wallet_balance');
     $data['status'] = $reversedCode['code'];$this->db->where('id',$id);$this->db->update('transactions',$data);
     $this->send_mail($userDetails['email'],$sub,$body);
    return false;    
}
 public function send_mail($to ='', $sub ='', $email_body=''){
  $this->load->library('phpmailer_lib');
  $from_name = get_settings('smtp_user');
  $app_name = get_settings('app_name');
  $mail = $this->phpmailer_lib->load();
  $host = get_settings('smtp_host');
  $port = get_settings('smtp_port');
  $user = get_settings('smtp_user');
  $pass = get_settings('smtp_pass');
  $mail->isSMTP();
  $mail->Host     = $host;
  $mail->SMTPAuth = true;
  $mail->Username = $user;
  $mail->Password = $pass;
  $mail->SMTPSecure = 'ssl';
  $mail->Port    = $port;
  $mail->setFrom($from_name, $app_name);
  $mail->addAddress($to);
  $mail->Subject = $sub;
  $mail->isHTML(true);
  $mailContent = $email_body;
  $mail->Body = $mailContent;
  if(!$mail->send()){
      return false;
  }else{
     return true;
   
  }
 }
}