<?php
defined('BASEPATH') OR exit('No direct script access allowed');
// Including Phil Sturgeon's Rest Server Library in our Server file.

require APPPATH . '/libraries/REST_Controller.php';

class Apiv2 extends REST_Controller{
// Load model in constructor
public function __construct() {
    parent::__construct();
$this->load->database();
//Allowed API Headers
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
    header("Access-Control-Allow-Methods: POST");
    header("Allow: POST, OPTIONS, PUT, DELETE");
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");
}
public function escapeString($string) {
   return remove_invisible_characters(html_escape($this->input->post($string)));
  }

public function authentication($token='')
    {
        $requestMethod = $_SERVER["REQUEST_METHOD"]; 
        $headers = apache_request_headers();
    /*if ($requestMethod !== 'POST') {
        header('HTTP/1.0 400 Bad Request');
        $response["status"] = "fail";
        $response["msg"] = "Only POST method is allowed";
        echo json_encode($response); exit(); 
    }
    */
    if($token !='')
    {
        $result=$this->User_model->validateAccessToken($token);
        return $result;
    }
       if((isset($headers['Authorization']) || isset($headers['authorization'])) || (isset($headers['Token']) || isset($headers['token']))){
        if((isset($headers['Authorization']) || isset($headers['authorization']))){
            $token = trim(str_replace("Bearer", "", (isset($headers['Authorization'])) ? $headers['Authorization'] : $headers['authorization']));
        }
        if((isset($headers['Bearer']) || isset($headers['bearer']))){
            $token = trim(str_replace("Bearer", "", (isset($headers['Bearer'])) ? $headers['Bearer'] : $headers['bearer']));
        }
        
        $result=$this->User_model->validateAccessToken($token);
        if($result == false){
            // tell the user no products found
            header('HTTP/1.0 401 Unauthorized');
            $response["status"] = "fail";
            $response["msg"] = "Authorization token not found $token";
            echo json_encode($response); exit(); 
        }
        else{
            return $result;
         }
    }
    else{
        header('HTTP/1.0 401 Unauthorized');
        // tell the user no products found
        $response["status"] = "fail";
        $response["msg"] = "Your authorization token is required.";
        echo json_encode($response); exit(); 
    }
  }

public function random_strings($length_of_string)
{
$str_result = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
return substr(str_shuffle($str_result),
                   0, $length_of_string);
}
public function doResponse($status,$msg,$title,$data='')
{
        $response['status']=$status;
        $response['msg']= $msg;
        if($data !=''){
        $response['data']=$data;
        }
        header('HTTP/1.0 200 '.$title);
        echo json_encode($response);
        exit;
}
public function uniqueidwithlenght($lenght)
  {
    $un = substr(number_format(time() * rand(),0,'',''),0,$lenght);
    return $un;
  }
 public function register_POST() 
{
    if($this->User_model->get_module('19') == false){
       $this->doResponse($status=false,$msg="Registration is temporary disabled. Please check back later",$title="Failed");
    }
    $email = $this->escapeString('email');
    $phonenumber = $this->escapeString('phone');
    $password = $this->escapeString('password');
    $security_pin = $this->escapeString('security_pin');
   $apiKey = substr(str_shuffle("0123456789ABCDEFGHIJklmnopqrstvwxyzAbAcAdAeAfAgAhBaBbBcBdC1C23C3C4C5C6C7C8C9xix2x3"), 0, 60).time();
    if(strlen($security_pin) !='4')
    {
        $this->doResponse($status=false,$msg="Security PIN should be 4digit",$title="Failed");
    }
    if(strlen($phonenumber) !='11')
    {
       $this->doResponse($status=false,$msg="Invalid Phone Number",$title="Failed");
    }
    $verify = $this->Auth_model->loginwithEmailPhone($email,$phonenumber);
    if($verify != false)
  {
     $this->doResponse($status=false,$msg="The email/Phone you entered already exist on our platform. Please use forget password to login to your existing account",$title="Failed");
     exit;
  }
  
/*	if($password != $confirmpassword)
    {
         $this->doResponse($status=false,$msg="Password mismatch. Your password and confirm password do not match",$title="Failed");
       
    }
*/
    if((checkBlacklist($phonenumber) == true)||(checkBlacklist($email) == true))
        {
           $this->doResponse($status=false,$msg="Unable to register this account. Please contact support",$title="Failed");
          
        }
    $firstname = removeSpaces($this->escapeString('firstname'));
    $lastname = removeSpaces($this->escapeString('lastname'));
    $fullname = $firstname.' '.$lastname;
    $password_lenght = strlen($password);
    $minimumPassword = get_settings('password_lenght');
        if($password_lenght < $minimumPassword)
           {
               $this->doResponse($status=false,$msg="Minimum of '.$minimumPassword.' character is required for your password",$title="Failed");
             
           }
           if((empty($phonenumber)||empty($email)))
           {
           $this->doResponse($status=false,$msg="Email address and Phone Number is required",$title="Failed");
             
           }
    if (isset($_POST['referral'])){$referral = $this->escapeString('referral');}else{$referral = '';}
    if($referral !=''){ 
        $check = $this->Auth_model->validate_refcode($referral);
        if($check != false)
        {
            $sponsor_id = $check['phone']; 
        }else{
            $this->doResponse($status=false,$msg="Invalid Referral Link. No account found with the referral link",$title="Failed");
            
        }
    }else{
        $sponsor_id = '';
    }
    $token = $this->uniqueidwithlenght('5');
    $userData = array(
        'email' => $email,
        'phone' => $phonenumber,
        'fullname' => $fullname,
        'api_key'=> $apiKey,
         'password' => password_hash($password, PASSWORD_BCRYPT),
         'sponsor_id' => $sponsor_id,
         'security_pin' => $security_pin,
         'activation_status'=>'0',
         'activation_token' => $token,
         'referral_code' =>$this->random_strings('4')
        
    );
    $checkPhone = $this->Auth_model->check_exist($phonenumber,$email);
             if(($checkPhone == false)){
                $insert = $this->Auth_model->register_new($userData);
           // $this->sendVerificationMail($email,$token);
            $this->doResponse($status=true,$msg="Thank you for creating account with us. Please login.",$title="Success");
            }else{
            $this->doResponse($status=false,$msg="Account could not be created. It seems you have account with us. Forget password? please use the forget password link",$title="Failed");
        }
    }

public function login_POST() 
{
    if($this->User_model->get_module('18') == false){
       $this->doResponse($status=false,$msg="Login is temporary disabled. Please check back later",$title="Failed");
    }
   
        $phonenumber = $this->escapeString('phone');
        $password = $this->escapeString('password');
        if(checkBlacklist($phonenumber) == true)
        {
         $this->doResponse($status=false,$msg="Unable to login this account. Please contact support",$title="Failed");
        }
       $result = $this->Auth_model->checkEmailorPhone($phonenumber);
       if($result == false)
       {
        $this->doResponse($status=false,$msg="Invalid Username Or Password",$title="Failed");
       }
       if($result['suspend'] == 1){
           $this->doResponse($status=false,$msg="Account Blocked, Please Contact Customer Support For Additional Information",$title="Failed");
       }
       $apiKey = substr(str_shuffle("0123456789ABCDEFGHIJklmnopqrstvwxyzAbAcAdAeAfAgAhBaBbBcBdC1C23C3C4C5C6C7C8C9xix2x3"), 0, 60).time();
          if($result['api_key'] == '')
           {
            $dataKey['api_key'] = $apiKey;
            $this->db->where('accountid',$result['accountid']);
            $this->db->update('account',$dataKey);
           }
           if($result['dailyLimit'] == '0')
           {
               $dataLimit['dailyLimit'] = get_settings('dailyLimit');
               $this->db->where('accountid',$result['accountid']);
               $this->db->update('account',$dataLimit);
           }
          
      /*    if($result['activation_status'] == '1')
          {
              $this->sendVerificationMail($result['email'],$result['activation_token']);
          }
        */
        
       if (password_verify($password, $result['password'])) 
        {
            if($result['referral_code'] == '')
           {
             $dataRefCode['referral_code'] = $this->random_strings('4');
               $this->db->where('accountid',$result['accountid']);
               $this->db->update('account',$dataRefCode);
           }
           
            $resultB = $this->Auth_model->checkEmailorPhone($phonenumber);
            $this->create_session($resultB);
            //$this->login_notification($resultB);
            $this->doResponse($status=true,$msg='Welcome back, '.$resultB['fullname'],$title='',$resultB);
         }else{
       $this->doResponse($status=false,$msg='Invalid Username Or Password',$title="Failed");
       }
 }
 public function sendVerificationMail($email,$token)
{
      $to = $email;
      $sub = 'Complete your registration on '.get_settings('app_name');
      $page_data['token'] = $token;
      $page_data['to'] = $to;
      $page_data['subject'] = $sub;
       $message = $this->load->view('Auth/Emails/app_confirm_email',$page_data,TRUE);
      if($this->send_mail($to,$sub,$message)){
           $this->doResponse($status=false,$msg="Thank you for creating account with us. Please check your email for verification instructions.",$title="Success");
      }else{
       return false;
      }
}

  public function uniqueid()
  {
    $string = generator('15');
    $reference = 'App_'.$string;
    return $reference;
  }
  public function convertTV($name)
 {
     if($name == 'DSTV'){
         return '01';
     }if($name == 'GOTV'){
         return '02';
     }if($name == 'STARTIMES'){
         return '03';
     }if($name == 'SHOWMAX'){
         return '04';
     }
     return $name;
 }

 public function validateMeter_POST()
    {
        $token = $this->escapeString('token');  
         $udetails = $this->authentication($token);
         $user_id = $udetails['accountid'];
        $provider = $this->escapeString('provider');
        $disco = get_DiscoElec($provider)->row_array();
        $meterNumber = $this->escapeString('meterNumber');
        $curl = curl_init();
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'verifyMeter/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
					"provider": "'.$disco['name'].'",
					"meternumber": "'.$meterNumber.'",
					"metertype" : "'.$this->escapeString('metertype').'"
				}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    //print_r($response);
    //exit;
    $result = json_decode($response,true);
    curl_close($curl);
  if($result['status'] == "success"){ 
				 $this->doResponse($status=true,$msg=$result['msg'],$title="Success");;
			}
			else{
			    $this->doResponse($status=true,$msg=$result['msg'],$title="Success");;
			}
    }
     public function verifybankAccount_POST()
    {
         /*$token = $this->escapeString('token');  
         $udetails = $this->authentication($token);
         $user_id = $udetails['accountid'];
         */
        $bankCode = $this->escapeString('bankCode');
        //$provider = $this->convertTV($cabletv);
        $authorization = $this->monify_auth();
        $accountNumber = $this->escapeString('accountNumber');
          $curl = curl_init();
     curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.monnify.com/api/v1/disbursements/account/validate?accountNumber='.$accountNumber.'&bankCode='.$bankCode,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
  
  CURLOPT_HTTPHEADER => array(
     'Content-Type: application/json',
    'Authorization: bearer '.$authorization
  ),
));
       $response = curl_exec($curl);
      curl_close($curl);
        $result = json_decode($response,true);
   if(($result['responseMessage'] == "success") &&(isset($result['responseBody']['accountName']))){ 
				 $this->doResponse($status=true,$msg=$result['responseBody']['accountName'],$title="Success");;
			}
			else{
			    $this->doResponse($status=true,$msg=$result['msg'],$title="Success");;
			}
    }
   public function verifyTV_POST()
    {
         $token = $this->escapeString('token');  
         $udetails = $this->authentication($token);
         $user_id = $udetails['accountid'];
        $cabletv = $this->escapeString('cabletv');
        $provider = $this->convertTV($cabletv);
        $iucnumber = $this->escapeString('iucnumber');
        $curl = curl_init();
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'verifytv/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
					"provider": "'.$provider.'",
					"iucnumber": "'.$iucnumber.'"
				}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
   if($result['status'] == "success"){ 
				 $this->doResponse($status=true,$msg=$result['msg'],$title="Success");;
			}
			else{
			    $this->doResponse($status=true,$msg=$result['msg'],$title="Success");;
			}
    }
    public function cashWithdraw_POST()
    {
       if($this->User_model->get_module('2') == false){
        $this->doResponse($status=false,$msg='Service is disabled. Please check back later',$title="Failed");
        }
        
    $token = $this->escapeString('token');  
    $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    $bank = $this->escapeString('bank');  
   // $networkID = $this->convertNetwork($network);
    $curl = curl_init();
    $pin = $this->escapeString('pin');
    $activity = "Data";
    if(checkBlacklist($this->escapeString('accountNumber')) == true)
        {
            $this->doResponse($status=false,$msg="Error occured while perform this transaction. Please contact support",$title="Failed");
             exit; 
        }
    $transref = $this->uniqueid();
    if($pin == $udetails['security_pin'])
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'cashWithdraw/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"bank": "'.$bank.'",
    						"accountNumber": "'.$this->escapeString('accountNumber').'",
    						"accountTitle": "'.$this->escapeString('accountTitle').'",
    						"ref" : "'.$transref.'",
    						"amount": "'.$this->escapeString('amount').'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
       // $this->User_model->updateBalances($result['id'],$udetails['wallet_balance']);
				 $this->doResponse($status=true,$msg='Withdrawal Request Submitted',$title="Success");
				}else{
				   $this->doResponse($status=false,$msg=$result['msg'],$title="Failed");
				}
    }else{
         $this->doResponse($status=false,$msg="Incorrect Pin, Please Try Again.",$title="Failed");
    }
    
    }
    
  public function data_POST()
    {
    if($this->User_model->get_module('2') == false){
        $this->doResponse($status=false,$msg='Service is disabled. Please check back later',$title="Failed");
    }  
    $token = $this->escapeString('token');  
    $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    $network = $this->escapeString('network');  
    $networkID = $this->convertNetwork($network);
    $curl = curl_init();
    $pin = $this->escapeString('pin');
    $ported_number = "false";
    $activity = "Data";
    if(checkBlacklist($this->escapeString('phone')) == true)
        {
          $this->doResponse($status=false,$msg='Unable to complete this transaction. Please contact Admin',$title="Success");
          exit; 
        }
    $transref = $this->uniqueid();
    if($pin == $udetails['security_pin'])
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'data/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"network": "'.$networkID.'",
    						"mobile_number": "'.$this->escapeString('phone').'",
    						"ported_number":"'.$ported_number.'",
    						"ref" : "'.$transref.'",
    						"plan": "'.$this->escapeString('plan').'",
    						"subtype" : "'.$this->escapeString('subtype').'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
        $this->User_model->updateBalances($result['id'],$udetails['wallet_balance']);
				 $this->doResponse($status=true,$msg='Transaction is successful',$title="Success");
				}else{
				   $this->doResponse($status=false,$msg=$result['msg'],$title="Failed");
				}
    }else{
         $this->doResponse($status=false,$msg="Incorrect Pin, Please Try Again.",$title="Failed");
    }
}
public function airtimeCash_POST()
    {
       if($this->User_model->get_module('2') == false){
        $this->doResponse($status=false,$msg='Service is disabled. Please check back later',$title="Failed");
        }
        
    $token = $this->escapeString('token');  
    $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    //$network = $this->escapeString('network');  
    //$networkID = $this->convertNetwork($network);
    $curl = curl_init();
    $ref = $this->escapeString('ref');
    $otp = $this->escapeString('otp');
    $authPIN = $this->escapeString('pin');
    $details = $this->db->get_where('airtimeConverter',array('reference' => $ref));
    if($details->num_rows() < 1){
       $this->doResponse($status=false,$msg="Invalid reference number",$title="Failed");
             exit;  
    }
    $detailsRow = $details->row_array();
    $activity = "Airtime to Cash";
    if(checkBlacklist($detailsRow['phone']) == true)
        {
            $this->doResponse($status=false,$msg="Error occured while perform this transaction. Please contact support",$title="Failed");
             exit; 
        }
    $transref = $ref;
   
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'airtimeCash/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"network": "'.$detailsRow['network'].'",
    						"otp": "'.$otp.'",
    						"ref" : "'.$ref.'",
    						"sendingNumber": "'.$detailsRow['phone'].'",
    						"amount": "'.$detailsRow['amount'].'",
    						"identifier":"'.$detailsRow['reference'].'",
    						"pin": "'.$authPIN.'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
       // $this->User_model->updateBalances($result['id'],$udetails['wallet_balance']);
				 $this->doResponse($status=true,$msg='Request Submitted',$title="Success");
				}else{
				   $this->doResponse($status=false,$msg=$result['msg'],$title="Failed");
				}
   
    
    }
    
public function getOTPAirtimeCash_POST()
{
    if($this->User_model->get_module('7') == false){
       $this->doResponse($status=false,$msg="Service is temporary disabled. Please check back later",$title="Failed");
    }
   
    $token = $this->escapeString('token'); 
    $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    $network = $this->escapeString('network');
    $networkID = $this->convertNetwork($network);
    $phone = $this->escapeString('sendingNumber');
    $pin = $this->escapeString('pin');
    $amount = (float)$this->escapeString('amount');
    $year = date('Y');
    $transref = $year.$this->uniqueidwithlenght('24');
    if(checkBlacklist($phone) == true)
        {
            $this->doResponse($status=false,$msg="Error occured while perform this transaction. Please contact support",$title="Failed");
             exit; 
        }
     if($pin == $udetails['security_pin'])
    {
         $curl = curl_init();
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'airtimeCashOTP/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"network": "'.$networkID.'",
    						"phone": "'.$this->escapeString('sendingNumber').'",
    						"amount": "'.$amount.'",
    						"ref" : "'.$transref.'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $responseA = curl_exec($curl);
    $result = json_decode($responseA,true);
    curl_close($curl);
   if($result['status'] == "success" || $result['status'] == "processing"){
       $title="Success";
       $response['status']= true;
        $response['msg']= $result['msg'];
        $response['ref']=$result['ref'];
        header('HTTP/1.0 200 '.$title);
        echo json_encode($response);
        exit;
			//	 $this->doResponse($status=true,$msg= $result['msg'],$title="Success",$data=$result['ref']);
	}else{
	  //  print_r($result);
		$this->doResponse($status=false,$msg="Failed",$title="Failed");
				 }
    }else{
        $this->doResponse($status=false,$msg="Incorrect Pin, Please Try Again.",$title="Failed");
    }
}
 public function airtime_POST()
    {
    if($this->User_model->get_module('1') == false){
          $this->doResponse($status=false,$msg='Service is disabled. Please check back later',$title="Failed");
      }        
    $token = $this->escapeString('token');  
    $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    $network = $this->escapeString('network');  
    $networkID = $this->convertNetwork($network);
    $curl = curl_init();
    $pin = $this->escapeString('pin');
    $amount = $this->escapeString('amount');
    $ported_number = "false";
    $activity = "Airtime";
    if(checkBlacklist($this->escapeString('phone')) == true)
        {
             $this->doResponse($status=false,$msg='Error occured while perform this transaction. Please contact support',$title="Failed");
       
        }
     $transref = $this->uniqueid();
     $airtimeID = $this->db->get_where('sub_module',array('network_id' => $networkID,'parent_id'=> '1'))->row_array();
    if($pin == $udetails['security_pin'])
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'airtime/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"network": "'.$networkID.'",
    						"amount": "'.$this->escapeString('amount').'",
    						"phone": "'.$this->escapeString('phone').'",
    						"ported_number":false,
    						"airtime_type": "'.$airtimeID['id'].'",
    						"ref" : "'.$transref.'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
   if($result['status'] == "success" || $result['status'] == "processing"){
				 $this->session->set_flashdata('success_msg', $result['msg']);
				 $this->User_model->updateBalances($result['id'],$udetails['wallet_balance']);
				 $this->doResponse($status=true,$msg='Transaction is successful',$title="Success");
				}else{
				    $this->doResponse($status=false,$msg=$result['msg'],$title="Failed");
				    
				}
    }else{
        $this->doResponse($status=false,$msg="Incorrect Pin, Please Try Again.",$title="Failed");
      
    }
}
 public function convertNetwork($name)
 {
     if($name == 'MTN'){
         return '01';
     }if($name == 'AIRTEL'){
         return '04';
     }if($name == 'GLO'){
         return '02';
     }if($name == '9MOBILE'){
         return '03';
     }
     return $name;
 }
 public function cableplan_GET()
 {
     if((isset($_GET['cabletv']))&&(!empty($_GET['cabletv'])))
         {
             $networkID = $this->convertTV($_GET['cabletv']);
           foreach(get_CablePlanAPI($networkID)->result_array() as $list){
              $postData[] = $list;
            }
            $this->doResponse($status=true,$msg='Data Types',$title="",$data=$postData);
         }else{
             $this->doResponse($status=false,$msg='Please select a network',$title="Failed");
         }
 }
 public function gettvPrice_GET()
{
    if((isset($_GET['cabletv']))&& (!empty($_GET['cabletv'])))
     {
         $cabletv = $_GET['cabletv'];
     }else{
    $this->doResponse($status=false,$msg='No TV Selected',$title="Failed");
     exit;
     }
     
     if((isset($_GET['plan']))&& (!empty($_GET['plan'])))
     {
         $plan = $_GET['plan'];
     }else{
     $this->doResponse($status=false,$msg='No Plan Selected',$title="Failed");
     exit;
     }
     if((isset($_GET['token']))&& (!empty($_GET['token'])))
     {
         $token = $_GET['token'];
     }else{
     $this->doResponse($status=false,$msg='Token is required',$title="Failed");
     exit;
     }
    // $userDetails = $this->userType($token);
     $currency = currency();
     $get_network = $this->convertTV($cabletv);
     $get_databundle = get_tvplanPrice($plan)->row_array(); 
   	   $send_reseponse = array('data' =>$get_databundle['price']);	 
   	  $this->doResponse($status=true,$msg='price fetched successfully',$title="",$data=$get_databundle['price']);
   	   exit;
}    
  public function disco_GET()
 {
            foreach(getElectricityProvider()->result_array() as $list){
               $postData[] = array('id' => $list['id'],'provider' => $list['name']);
            // $postData[] = $list;
            }
            $this->doResponse($status=true,$msg='Data Types',$title="",$data=$postData);
        
 }
 public function banks_GET()
 {
            foreach(getBanks()->result_array() as $list){
              $postData[] = $list;
            }
            $this->doResponse($status=true,$msg='Data Types',$title="",$data=$postData);
        
 }
  public function getdatatype_GET()
 {
     if((isset($_GET['network']))&&(!empty($_GET['network'])))
         {
             $postData = array();
             $networkID = $this->convertNetwork($_GET['network']);
            $result = $this->User_model->sub_module($id='2',$networkID); 
           // print_r($result);
           // exit;
            foreach($result->result_array() as $list){
              $postData[] = $list;
            }
            $this->doResponse($status=true,$msg='Data Types',$title="",$data=$postData);
         }else{
             $this->doResponse($status=false,$msg='Please select a network',$title="Failed");
         }
 }
 public function notification_GET()
{
    $status = '0';
   $announcement = get_settings('announcement');
     $this->doResponse($status=true,$msg=$announcement,$title="");
    
}
public function getExamPrice_GET()
{
    if((isset($_GET['ExamType']))&& (!empty($_GET['ExamType'])))
     {
    $getExamType = $_GET['ExamType'];
    $result = $this->db->get_where('network', array('module_id'=>'8','network_name'=>$getExamType));
     foreach($result->result_array() as $list){
          $postData[] = $list;
        }
        $this->doResponse($status=true,$msg='Exam price fetched',$title="",$data=$postData);
     }else{
        
     $this->doResponse($status=false,$msg='No Exam Selected',$title="");
     }
}
public function getExams_GET()
{
    $result = $this->User_model->getNetwork($module='8');
     foreach($result as $list){
          $postData[] = $list;
        }
        $this->doResponse($status=true,$msg='Exam fetched',$title="",$data=$postData);
}
public function exampin_POST()
  {
      $token = $this->escapeString('token');  
    $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    $curl = curl_init();
    $pin = $this->escapeString('pin');
    $activity = "Exam PIN";
   $transref = $this->uniqueid();
   if($pin == $udetails['security_pin'])
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'exam/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"provider": "'.$this->escapeString('provider').'",
    						"quantity": "'.$this->escapeString('quantity').'",
    						"ref" : "'.$transref.'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
				    $this->doResponse($status=true,$msg='Transaction successful',$title="Success");
				}else{
				     $this->doResponse($status=false,$msg='Transaction failed',$title="Failed");
				}
    }else{
        $this->doResponse($status=false,$msg='Incorrect Pin, Please Try Again',$title="Failed");
    }
  }
  public function upgrade_POST()
 {
     $token = $this->escapeString('token');  
    $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    $pin = $this->escapeString('pin');
    $transref = $this->uniqueid();
    $charge = get_settings('upgradeFee');
    if($pin == $udetails['security_pin'])
    {
        if($udetails['wallet_balance'] >= $charge)
        {
            $data['wallet_balance'] = ($udetails['wallet_balance'] - $charge);
            $data['package_id'] = ($udetails['package_id'] + 1);
            $this->db->where('accountid',$udetails['accountid']);
            $this->db->update('account',$data);
             $this->doResponse($status=true,$msg='Transaction successful',$title="Success");
        }else{
           $this->doResponse($status=false,$msg='Insufficient wallet balance',$title="Failed");
        }
    }else{
        $this->doResponse($status=false,$msg='Incorrect Pin, Please Try Again',$title="Failed");
    }
    
 }
 
 public function referrals_GET()
 {
     if((isset($_GET['token']))&&(!empty($_GET['token']))){
    $token = $_GET['token'];
     }else{
          $this->doResponse($status=false,$msg='Token is missing',$title="Failed");
     }
    $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    $result = getDownlines($udetails['accountid']);
 if($result->num_rows() < 1)
 {
     $this->doResponse($status=false,$msg='No data found',$title="Failed");
        exit;
 }
  foreach($result->result_array() as $list){
          $postData[] = $list;
        }
       $this->doResponse($status=true,$msg='Report fetched',$title="",$data=$postData);
 }
 public function walletSummary_GET()
 {
     if((isset($_GET['token']))&&(!empty($_GET['token']))){
    $token = $_GET['token'];
     }else{
          $this->doResponse($status=false,$msg='Token is missing',$title="Failed");
     }
    $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    $result = getDeposits($udetails['accountid']);
 if($result->num_rows() < 1)
 {
     $this->doResponse($status=false,$msg='No transaction found',$title="Failed");
        exit;
 }
  foreach($result->result_array() as $list){
          $postData[] = $list;
        }
       $this->doResponse($status=true,$msg='Report fetched',$title="",$data=$postData);
 }
 
  public function history_GET()
 {
     if((isset($_GET['token']))&&(!empty($_GET['token']))){
    $token = $_GET['token'];
 }else{
      $this->doResponse($status=false,$msg='Token is missing',$title="Failed");
 }
 
 if((isset($_GET['type']))&&(!empty($_GET['type']))){
    $type = $_GET['type'];
 }else{
      $this->doResponse($status=false,$msg='Type is missing',$title="Failed");
 }
 $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
 $module = $this->convertModule($type);
 $result = getHistory($udetails['accountid'],$module);
 if($result->num_rows() < 1)
 {
     $this->doResponse($status=false,$msg='No transaction found',$title="Failed");
        exit;
 }
  foreach($result->result_array() as $list){
          $postData[] = $list;
        }
       $this->doResponse($status=true,$msg='Report fetched',$title="",$data=$postData);
        
    
 }
 function convertModule($type)
 {
     if($type == 'Airtime')
     {
         return '1';
     }
     if($type == 'Data')
     {
         return '2';
     }
     if($type == 'Cable')
     {
         return '3';
     }
     if($type == 'Electricity')
     {
         return '4';
     }
     if($type == 'Airtime PIN')
     {
         return '5';
     }
 }

  public function airtimepin_POST()
  {
      $token = $this->escapeString('token');  
    $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    $networkName = $this->escapeString('network'); 
    $get_network = $this->convertNetwork($networkName);
    $curl = curl_init();
    $pin = $this->escapeString('pin');
   $activity = "AirtimePIN";
    $transref = $this->uniqueid();
     if($pin == $udetails['security_pin'])
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'rechargepin/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"name_on_card": "'.$this->escapeString('businessname').'",
    						"network": "'.$get_network.'",
    						"ref" : "'.$transref.'",
    						"amount" : "'.$this->escapeString('amount').'",
    						"quantity": "'.$this->escapeString('quantity').'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
				    $this->doResponse($status=true,$msg='Transaction successful',$title="Success");
				}else{
				     $this->doResponse($status=false,$msg='Transaction failed',$title="Failed");
				}
    }else{
        $this->doResponse($status=false,$msg='Incorrect Pin, Please Try Again',$title="Failed");
    }
  }
 public function bulksms_POST()
  {
     $token = $this->escapeString('token');  
    $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    $curl = curl_init();
    $pin = $this->escapeString('pin');
    $sender = $this->escapeString('sender');
    $activity = "Bulksms";
   $transref = $this->uniqueid();
   if($pin == $udetails['security_pin'])
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'sendSMS/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"sender": "'.$this->escapeString('sender').'",
    						"recipients": "'.$this->escapeString('recipients').'",
    						"message": "'.$this->escapeString('message').'",
    						"ref" : "'.$transref.'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Bearer:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
				    $this->doResponse($status=true,$msg='Transaction successful',$title="Success");
				}else{
				    $this->doResponse($status=false,$msg='Transaction failed',$title="Failed");
				}
    }else{
        $this->doResponse($status=false,$msg='Incorrect Pin, Please Try Again',$title="Failed");
    }
  }
  public function buyCable_POST()
  {
      if($this->User_model->get_module('3') == false){
           $this->doResponse($status=false,$msg='Service is disabled. Please check back later',$title="Failed");
          
      }
      $token = $this->escapeString('token');  
    $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    $networkName = $this->escapeString('cabletv');   
     $networkID = $this->convertTV($networkName);
    $curl = curl_init();
    $pin = $this->escapeString('pin');
   $activity = "Cable";
   if(checkBlacklist($this->escapeString('iucnumber')) == true)
        {
            $this->doResponse($status=false,$msg='Error occured while perform this transaction. Please contact support',$title="Failed");
          exit; 
        }
    $transref = $this->uniqueid();
   if($pin == $udetails['security_pin'])
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'purchaseTV/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"provider": "'.$networkID.'",
    						"iucnumber": "'.$this->escapeString('iucnumber').'",
    						"ref" : "'.$transref.'",
    						"plan": "'.$this->escapeString('plan').'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
        $this->User_model->updateBalances($result['id'],$udetails['wallet_balance']);
				 $this->doResponse($status=true,$msg='Transaction successful',$title="Success");
				}else{
				    $this->doResponse($status=false,$msg='Transaction failed',$title="Failed");
				}
    }else{
         $this->doResponse($status=false,$msg='Incorrect Pin, Please Try Again',$title="Failed");
        
    }
  }
  public function Changepassword_POST()
  {
    $token = $this->escapeString('token');   
   $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    $current_password =$this->escapeString('oldpassword');
    $new_password = $this->escapeString('newpassword');
    $confirm_password = $this->escapeString('confirmNew');
    if($new_password != $confirm_password)
    {
       $this->doResponse($status=false,$msg='New password and confirm new password does not match',$title="Failed");
        exit;    
    }
    $check_old_password = $this->User_model->check_old_password($udetails['accountid'],$current_password);
    if($check_old_password)
    {
     $do_password_update = $this->User_model->do_password_update($udetails['accountid'],$new_password);  
     if($do_password_update){
        $this->doResponse($status=true,$msg='Your Account Password has been successfully updated',$title="Success");
       exit; 
     }
    }else{
         $this->doResponse($status=false,$msg='Current password is invalid',$title="Failed");
        exit; 
    }
  }
  public function Changepin_POST()
  {
    $token = $this->escapeString('token');   
   $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    $current_pin =$this->escapeString('current_pin');
    $new_pin = $this->escapeString('new_pin');
    $confirm_pin = $this->escapeString('confirm_pin');
    if($new_pin != $confirm_pin)
    {
       $this->doResponse($status=false,$msg='New password and confirm new password does not match',$title="Failed");
        exit;    
    }
    if($current_pin == $udetails['security_pin'])
    {
     $do_password_update = $this->User_model->do_update_update($udetails['accountid'],$new_pin);  
     if($do_password_update){
        $this->doResponse($status=true,$msg='Your Account PIN has been successfully updated',$title="Success");
       exit; 
     }
    }else{
         $this->doResponse($status=false,$msg='Current PIN is invalid',$title="Failed");
        exit; 
    }
  }
public function buyElectricity_POST()
{
    if($this->User_model->get_module('4') == false){
         $this->doResponse($status=false,$msg='Service is disabled. Please check back later',$title="Failed");
          
      }
     $token = $this->escapeString('token'); 
     $disco_name = $this->escapeString('disco_name');
     $disco = get_DiscoElec($disco_name)->row_array();
     $udetails = $this->authentication($token);$user_id = $udetails['accountid'];
    $curl = curl_init();
    $pin = $this->escapeString('pin');
   $activity = "Electricity";
    if(checkBlacklist($this->escapeString('meternumber')) == true)
        {
             $this->doResponse($status=false,$msg='Error occured while perform this transaction. Please contact support',$title="Failed");
                exit;
        }
    $transref = $this->uniqueid();
    if($pin == $udetails['security_pin'])
    {
        curl_setopt_array($curl, array(
      CURLOPT_URL => host_site().'buyElectricity/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
    						"provider": "'.$disco['id'].'",
    						"meternumber": "'.$this->escapeString('meternumber').'",
    						"ref" : "'.$transref.'",
    						"amount": "'.$this->escapeString('amount').'",
    						"metertype":"'.$this->escapeString('metertype').'"
    					}',
      CURLOPT_HTTPHEADER => array(
        'Token:'.$udetails['api_key'],
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    $result = json_decode($response,true);
    curl_close($curl);
    if($result['status'] == "success" || $result['status'] == "processing"){
        $this->User_model->updateBalances($result['id'],$udetails['wallet_balance']);
				 $this->doResponse($status=true,$msg='Transaction successful',$title="Success");
				 exit;
				}else{
				    $this->doResponse($status=false,$msg='Transaction failed',$title="Failed");
				    exit;
				}
    }else{
         $this->doResponse($status=false,$msg='Incorrect Pin, Please Try Again',$title="Failed");
         exit;
    }
}

 public function getdataplan_GET()
 {
     if((isset($_GET['datatype']))&&(!empty($_GET['datatype'])))
         {
            // $networkID = $this->convertNetwork($_GET['datatype']);
            $result = $this->User_model->getPlanbyNetwork($_GET['datatype']); 
            foreach($result->result_array() as $list){
              $postData[] = $list;
            }
            $this->doResponse($status=true,$msg='Data Plans',$title="",$data=$postData);
         }else{
             $this->doResponse($status=false,$msg='Please select a network',$title="Failed");
         }
 }
  public function getplan_get()
{
 if((isset($_GET['network']))&& (!empty($_GET['network'])))
     {
        $type = $_GET['type'];
        $network =  $_GET['network'];
        $get_network = $this->convertNetwork($network);
        $subtype = $this->db->get_where('sub_module', array('name'=>$type))->row_array();
         $get_databundle = $this->User_model->getPlanbyNetworkIDANDdataType($get_network,$subtype['id']); 
   	   $num_of_rows = $get_databundle->num_rows();
   	   foreach($get_databundle->result_array() as $list){
          $postData[] = $list;
        }
         $this->doResponse($status=true,$msg='Data Plans',$title="",$data=$postData);
     }else{
        $this->doResponse($status=false,$msg='Please select a network',$title="Failed");
     }
}
public function getPlanPrice_GET()
{
    if((isset($_GET['network']))&& (!empty($_GET['network'])))
     {
         $network = $_GET['network'];
     }else{
        $this->doResponse($status=false,$msg='No network selected',$title="Failed");
     exit;
     }
     
     if((isset($_GET['type']))&& (!empty($_GET['type'])))
     {
         $type = $_GET['type'];
     }else{
         
    $this->doResponse($status=false,$msg='No datatype selected',$title="Failed");
     exit;
     }
     
     if((isset($_GET['plan']))&& (!empty($_GET['plan'])))
     {
         $plan = $_GET['plan'];
     }else{
          $this->doResponse($status=false,$msg='Plan ID is required',$title="Failed");
     exit;
     }
     
     
     if((isset($_GET['token']))&& (!empty($_GET['token'])))
     {
         $token = $_GET['token'];
     }else{
     $this->doResponse($status=false,$msg='Token is required',$title="Failed");
     exit;
     }
     $userDetails = $this->userType($token,$plan);
     $send_reseponse = array('price' => $userDetails);
    $this->doResponse($status=true,$msg='Data Price',$title="",$data=$send_reseponse);
   exit;
}  
public function userType($token,$plan)
{
    $result = $this->User_model->get_user_price($token);
    $verifyplanID = $this->User_model->verifyPlanID($plan);
    if($verifyplanID == false){
        header('HTTP/1.0 400 Plan ID not available');
        $response['status']="fail";
        $response['msg'] = "Data Plan is not available on this network";
        echo json_encode($response);
        exit;
    }
    $planDetails = $verifyplanID->row_array();
   return  $planDetails[$result];
}
public function user_GET()
{
    $type ='';
    if((isset($_GET['user_id']))&&(!empty($_GET['user_id']))){
 $user_id = $_GET['user_id'];
 if((isset($_GET['type']))&&(!empty($_GET['type']))){
    $type = $_GET['type'];
 }
    $get_databundle = $this->User_model->fetcheUserDetails($user_id,$type);
   	   $num_of_rows = $get_databundle->num_rows();
   	   if($num_of_rows < 1)
   	   {
   	      $send_reseponse = array('data' => 'user not found');	
    print_r(json_encode($send_reseponse,JSON_PRETTY_PRINT));  
    exit; 
   	   }
   	   foreach($get_databundle->result_array() as $list){
          $postData = $list;
        }
        $send_reseponse = array('data' => $postData);	
         print_r(json_encode($send_reseponse,JSON_PRETTY_PRINT)); 
    }else{
        $send_reseponse = array('data' => 'user ID is empty');	
    print_r(json_encode($send_reseponse,JSON_PRETTY_PRINT));  
    exit;
    }
    
}
 public function user_POST()
 {
     $udetails = $this->authentication();
     $response['status']=true;
    $response['data'] = $udetails;
    $response['msg']= 'Welcome back, '.$udetails['fullname'];
    $response['Status']=ucwords($status);
    header('HTTP/1.0 200 Success');
    echo json_encode($response);
    exit;
     
 }
  public function create_session($result)
  {
       $session_id = sha1(time());
        $myTime = date('Y-m-d H:i:s', time());
        $ip_address = $this->input->ip_address(); 
         $this->Auth_model->update_session_id($result['accountid'],$session_id); 
        $result = $this->Auth_model->insert_login($result['accountid'],$ip_address,$session_id);
        return true;
  }
 
 public function fetchslider_get()
{
  
    $get_databundle = $this->db->get('mobile_slider');
   	   $num_of_rows = $get_databundle->num_rows();
   	   if($num_of_rows < 1)
   	   {
   	      $send_reseponse = array('data' => 'data not found');	
    print_r(json_encode($send_reseponse,JSON_PRETTY_PRINT));  
    exit; 
   	   }
   	   foreach($get_databundle->result_array() as $list){
          $postData[] = $list;
        }
        $send_reseponse = array('data' => $postData);	
         print_r(json_encode($send_reseponse,JSON_PRETTY_PRINT)); 
    
}
public function login_notification($result)
{           
            $to = $result['email'];
            $sub = 'New Login Notification on '.get_settings('app_name');
            $page_data['user_data'] = $result;
            $message = $this->load->view('Auth/Emails/login_email',$page_data,TRUE);
            $this->send_mail($to,$sub,$message);
         return true;
       
}
public function monify_auth(){
$apikey = payment_getways('3')['pk_live'];
$monify_secret = payment_getways('3')['sk_live'];
 if((empty($apikey))||(empty($monify_secret))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
  $curl = curl_init();
  curl_setopt($curl, CURLOPT_USERPWD, $apikey . ":" . $monify_secret);
curl_setopt_array($curl, array(
  CURLOPT_URL => "https://api.monnify.com/api/v1/auth/login",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_HTTPHEADER => array(
      "Content-Type: application/json",
  ),
));
$response = curl_exec($curl);
curl_close($curl);
$result = json_decode($response,true);
return $result['responseBody']['accessToken'];
  }
public function generatePalmPay_POST()
{
   if(empty(payment_getways('9')['pk_live']))
      {
          $this->doResponse($status=true,$msg='Account could not be generated Contact Admin',$title="",$data="");
            exit;
      }
       $token = $this->escapeString('token');  
       $udetails = $this->authentication($token);
      $reference = $this->uniqueid();
      // $udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();$user_id = $udetails['accountid'];
    $apiKey = payment_getways('9')['pk_live'];
     $secretKey = payment_getways('9')['sk_live'];
     $contract_code = payment_getways('9')['contract_code'];
      $callbackurl = base_url().'palmpaywebhook';
     
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.paymentpoint.co/api/v1/createVirtualAccount',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
  "email": "'.$udetails['email'].'",
  "name": "'.$udetails['fullname'].'",
  "phoneNumber": "'.$udetails['phone'].'",
  "bankCode": ["20946"],
  "businessId": "'.$contract_code.'"
}',
  CURLOPT_HTTPHEADER => array(
    'Authorization: Bearer '.$secretKey,
    'api-key: '.$apiKey,
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
$response = curl_exec($curl);

		//	print_r($response);
		//	exit;
			curl_close($curl);
			$value = json_decode($response, true);
			 if((isset($value['bankAccounts'][0]['accountNumber']) &&(!empty($value['bankAccounts'][0]['accountNumber'])))){
              $accnuban = $value['bankAccounts'][0]['accountNumber'];
               $data['palmpay'] = $value['bankAccounts'][0]['accountNumber'];
               $this->db->where('accountid',$udetails['accountid']);
               $this->db->update('account',$data);
        	  $this->doResponse($status=true,$msg='Account generated successfully',$title="",$data="");
            exit;
            }else{
           $this->doResponse($status=false,$msg='Account could not be generated Contact Admin',$title="",$data="");
            exit;
            }  
}
 public function do_payvesseslKYC($kycType,$kycNumber,$udetails)
{
    $payvesselApiKey = payment_getways('4')['pk_live'];
    $payvesselSecret = payment_getways('4')['sk_live'];
    $payvesselBusinesaccountid = payment_getways('4')['contract_code'];
  //if($kycType == 'bvn'){$type = 'bvn';$value = $kycNumber;}else{ $type = 'nin';$value = $kycNumber;}
    if((empty($payvesselApiKey))||(empty($payvesselSecret))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
  if(strpos(trim($udetails['fullname']), ' ') !== false)
    {
      $fullname =  $udetails['fullname'];
    }else{
       $fullname = $udetails['fullname'].' '.$udetails['fullname'];  
    }
    $curl = curl_init();
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.payvessel.com/api/external/request/customerReservedAccount/',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
    "email":"'.$udetails['email'].'",
    "name":"'.$fullname.'",
    "phoneNumber":"'.$udetails['phone'].'",
    "bankcode":["120001"],
    "account_type": "STATIC",
    "businessid":"'.$payvesselBusinesaccountid.'",
    "'.$kycType.'":"'.$kycNumber.'"
}',
 CURLOPT_HTTPHEADER => array(
    'api-key: '.$payvesselApiKey,
    'api-secret: Bearer '.$payvesselSecret,
    'Content-Type: application/json'
  ),
));
$response = curl_exec($curl);
$result = json_decode($response,true);
return $response;
//print_r($response);
//exit;
}
public function monnifyKyc($type,$kycNumber,$udetails)
{
    $apikey = payment_getways('3')['pk_live'];
       $monify_secret = payment_getways('3')['sk_live'];
       $monify_contract = payment_getways('3')['contract_code'];
            if((empty($apikey))||(empty($monify_secret))||(empty($monify_contract))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
               $authorization = $this->monify_auth();
               if(strpos(trim($udetails['fullname']), ' ') !== false)
                    {
                      $fullname =  $udetails['fullname'];
                    }else{
                       $fullname = $udetails['fullname'].' '.$udetails['fullname'];  
                    }
                $curl = curl_init();
             curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api.monnify.com/api/v2/bank-transfer/reserved-accounts",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
         CURLOPT_POSTFIELDS => json_encode([
        'accountReference'=>$this->uniqueid(),
        'accountName'=>$fullname,
        'currencyCode' => "NGN",
        $type => $kycNumber,
        'contractCode' => $monify_contract,
        'customerEmail'=> $udetails['email'],
        'customerName' => $fullname,
        'getAllAvailableBanks' => false,
        'preferredBanks' => ['50515']
      ]),
          CURLOPT_HTTPHEADER => array(
             'Content-Type: application/json',
            'Authorization: Bearer '.$authorization
          ),
        ));
       $response = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($response,true);
        return $response;
}
public function generateAllAccount_POST()
  {
      if(empty(payment_getways('3')['pk_live']))
      {
            $this->doResponse($status=true,$msg='Account could not be generated Contact Admin',$title="",$data="");
            exit;
      }
      $token = $this->escapeString('token');  
      $bvn = $this->escapeString('bvn');  
      $nin = $this->escapeString('nin');
      if(!empty($bvn)){$kycType = 'bvn';$kycNumber = $bvn;}elseif(!empty($nin)){$kycType = 'nin';$kycNumber = $nin;}
      $udetails = $this->authentication($token);
      $reponse1 = $this->do_payvesseslKYC($kycType,$kycNumber,$udetails);
      $result1 = json_decode($reponse1,true);
      $reponse2 = $this->monnifyKyc($kycType,$kycNumber,$udetails);
      $result2 = json_decode($reponse2,true);
       $user_id = $udetails['accountid'];
       $fullname = $udetails['fullname'].' '.get_settings('app_name');
       if((isset($result1['banks'][0]['accountNumber']))&&(!empty($result1['banks'][0]['accountNumber']))){
            $account_number = $result1['banks'][0]['accountNumber'];
            $data['payvessel'] = $account_number;
            $data[$kycType] = $kycNumber;
            $this->db->where('accountid',$user_id);
            $this->db->update('account',$data);
      
        if((isset($result2['responseBody']['accounts'][0]['accountNumber']))&&(!empty($result2['responseBody']['accounts'][0]['accountNumber']))){
            $account_number = $result2['responseBody']['accounts'][0]['accountNumber'];
            $data['moniepoint'] = $account_number;
            $data[$kycType] = $kycNumber;
            $this->db->where('accountid',$user_id);
            $this->db->update('account',$data);
            $this->doResponse($status=true,$msg='Account generated successfully',$title="",$data=$account_number);
          exit;
        }else{
             $this->doResponse($status=false,$msg=$result2['responseMessage'],$title="",$data=$account_number);
            exit;
            }
        
       }else{
           $this->doResponse($status=false,$msg=$result1['message'],$title="",$data=$account_number);
            exit;
       }
         
  }
  public function generateMonniepoint($type,$value,$udetails){
      $apikey = payment_getways('3')['pk_live'];
       $monify_secret = payment_getways('3')['sk_live'];
       $monify_contract = payment_getways('3')['contract_code'];
       
    if((empty($apikey))||(empty($monify_secret))||(empty($monify_contract))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
       $authorization = $this->monify_auth();
        $curl = curl_init();
     curl_setopt_array($curl, array(
  CURLOPT_URL => "https://api.monnify.com/api/v2/bank-transfer/reserved-accounts",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_POSTFIELDS => json_encode([
        'accountReference'=>$this->uniqueid(),
        'accountName'=>$udetails['fullname'],
        'currencyCode' => "NGN",
        $type => $value,
        'contractCode' => $monify_contract,
        'customerEmail'=> $udetails['email'],
        'customerName' => $udetails['fullname'],
        'getAllAvailableBanks' => false,
        'preferredBanks' => ['50515']
      ]),
  CURLOPT_HTTPHEADER => array(
     'Content-Type: application/json',
    'Authorization: Bearer '.$authorization
  ),
));
       $response = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($response,true);
       if((isset($result['responseBody']['accounts'][0]['accountNumber']))&&(!empty($result['responseBody']['accounts'][0]['accountNumber']))){
            $account_number = $result['responseBody']['accounts'][0]['accountNumber'];
            $data['moniepoint'] = $account_number;
            $this->db->where('accountid',$udetails['accountid']);
            $this->db->update('account',$data);
       }
        return true;
 }
   public function do_payvessesl($type,$udetails)
{
     $user_id = $udetails['accountid'];
    $udetails = $this->db->get_where('account',array('accountid' => $user_id))->row_array();
     if($udetails['bvn'] != ''){$type = 'bvn';$value = $udetails['bvn'];}else{ $type = 'nin';$value = $udetails['nin'];}
    $payvesselApiKey = payment_getways('4')['pk_live'];
    $payvesselSecret = payment_getways('4')['sk_live'];
    $payvesselBusinesaccountid = payment_getways('4')['contract_code'];;
    //$udetails = $this->User_model->get_user_by_session($this->session->userdata('loginId'))->row_array();       $user_id = $udetails['accountid'];
    if((empty($payvesselApiKey))||(empty($payvesselSecret))){ $this->session->set_flashdata('error_message','Unable to continue with the request. Please contact support');redirect('addfund');}
    $curl = curl_init();
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.payvessel.com/api/external/request/customerReservedAccount/',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
    "email":"'.$udetails['email'].'",
    "name":"'.$udetails['fullname'].'",
    "phoneNumber":"'.$udetails['phone'].'",
    "bankcode":["120001"],
    "account_type": "STATIC",
    "businessid":"'.$payvesselBusinesaccountid.'",
    "'.$type.'":"'.$value.'"
}',
 CURLOPT_HTTPHEADER => array(
    'api-key: '.$payvesselApiKey,
    'api-secret: Bearer '.$payvesselSecret,
    'Content-Type: application/json'
  ),
));
$response = curl_exec($curl);
$result = json_decode($response,true);
 if((isset($result['banks'][0]['accountNumber']))&&(!empty($result['banks'][0]['accountNumber']))){
$account_number = $result['banks'][0]['accountNumber'];
$data['ninepayment'] = $account_number;
$this->db->where('accountid',$udetails['accountid']);
$this->db->update('account',$data);
}
return true;
//print_r($response);
}
  public function generatePSBAccount_POST()
  {
      if(empty(payment_getways('4')['pk_live']))
      {
          $this->doResponse($status=true,$msg='Account could not be generated Contact Admin',$title="",$data="");
            exit;
      }
      $token = $this->escapeString('token');  
      $udetails = $this->authentication($token);
      $user_id = $udetails['accountid'];
     if((empty($udetails['bvn']))&&((empty($udetails['nin'])))){
          $this->doResponse($status=true,$msg='Account could not be generated BVN is required',$title="",$data="");
            exit;
     }
     $result = $this->do_payvessesl($udetails);
     if((isset($result['banks'][0]['accountNumber']))&&(!empty($result['banks'][0]['accountNumber']))){
            $account_number = $result['banks'][0]['accountNumber'];
            $data['ninepayment'] = $account_number;
           $this->db->where('accountid',$user_id);
            $this->db->update('account',$data);
            $this->doResponse($status=true,$msg='Account generated successfully',$title="",$data=$account_number);
            exit;
            }else{
             $this->doResponse($status=true,$msg='Account could not be generated',$title="",$data= json_encode($result));
            exit;
            }
  }
  
  public function generateBanklyAccount_POST()
  {
      if(empty(payment_getways('9')['pk_live']))
      {
          $this->doResponse($status=true,$msg='Account could not be generated Contact Admin',$title="",$data="");
            exit;
      }
     $token = $this->escapeString('token');  
      $udetails = $this->authentication($token);
      $user_id = $udetails['accountid'];
    $apiKey = payment_getways('9')['pk_live'];
      $callbackurl = base_url().'strowalletwebhook';
       $url = "https://strowallet.com/api/virtual-bank/bankly";
             $curl = curl_init();
                 curl_setopt_array($curl, array(
				CURLOPT_URL =>  $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "POST",
				CURLOPT_POSTFIELDS => 
									'{
											"public_key": "'.$apiKey.'",
											"email": "'.$udetails['email'].'",
											"account_name": "'.$udetails['fullname'].'",
											"phone": "'.$udetails['phone'].'",
											"webhook_url": "'.$callbackurl.'"
										}',
				CURLOPT_HTTPHEADER => array(
					"Content-Type: application/json"
				),
			));  
			$response = curl_exec($curl);
			//print_r($response);
			//exit;
			curl_close($curl);
			$value = json_decode($response, true);
			 if((isset($value['account_number']) &&(!empty($value['account_number'])))){
              $accnuban = $value['account_number'];
               $data['bankly'] = $value['account_number'];
               $this->db->where('accountid',$udetails['accountid']);
               $this->db->update('account',$data);
        	   $this->doResponse($status=true,$msg='Account generated successfully',$title="",$data=$accnuban);
            exit;
            }else{
             $this->doResponse($status=true,$msg='Account could not be generated',$title="",$data= json_encode($value));
            exit;
            }
  }
  public function generateBanklyAccount($token)
  {
      if(empty(payment_getways('9')['pk_live']))
      {
          return false;
      }
      $udetails = $this->authentication($token);
      $user_id = $udetails['accountid'];
      $apiKey = payment_getways('9')['pk_live'];
      $callbackurl = base_url().'strowalletwebhook';
       $url = "https://strowallet.com/api/virtual-bank/bankly";
             $curl = curl_init();
                 curl_setopt_array($curl, array(
				CURLOPT_URL =>  $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "POST",
				CURLOPT_POSTFIELDS => 
									'{
											"public_key": "'.$apiKey.'",
											"email": "'.$udetails['email'].'",
											"account_name": "'.$udetails['fullname'].'",
											"phone": "'.$udetails['phone'].'",
											"webhook_url": "'.$callbackurl.'"
										}',
				CURLOPT_HTTPHEADER => array(
					"Content-Type: application/json"
				),
			));  
			$response = curl_exec($curl);
			//print_r($response);
			//exit;
			curl_close($curl);
			$value = json_decode($response, true);
			 if((isset($value['account_number']) &&(!empty($value['account_number'])))){
              $accnuban = $value['account_number'];
               $data['bankly'] = $value['account_number'];
               $this->db->where('accountid',$udetails['accountid']);
               $this->db->update('account',$data);
            return true;
            }else{
             return false;
            }
  }
  public function generatePagaAccount($token)
  {
      if(empty(payment_getways('9')['pk_live']))
      {
          return false;
      }
      $udetails = $this->authentication($token);
      $user_id = $udetails['accountid'];
      $apiKey = payment_getways('9')['pk_live'];
      $callbackurl = base_url().'strowalletwebhook';
       $url = "https://strowallet.com/api/virtual-bank/paga";
             $curl = curl_init();
                 curl_setopt_array($curl, array(
				CURLOPT_URL =>  $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "POST",
				CURLOPT_POSTFIELDS => 
									'{
											"public_key": "'.$apiKey.'",
											"email": "'.$udetails['email'].'",
											"account_name": "'.$udetails['fullname'].'",
											"phone": "'.$udetails['phone'].'",
											"webhook_url": "'.$callbackurl.'"
										}',
				CURLOPT_HTTPHEADER => array(
					"Content-Type: application/json"
				),
			));  
			$response = curl_exec($curl);
			//print_r($response);
			//exit;
			curl_close($curl);
			$value = json_decode($response, true);
			 if((isset($value['account_number']) &&(!empty($value['account_number'])))){
              $accnuban = $value['account_number'];
               $data['paga'] = $value['account_number'];
               $this->db->where('accountid',$udetails['accountid']);
               $this->db->update('account',$data);
            return true;
            }else{
             return false;
            }
  }
  public function fpassword_POST()
  {
    $phone = $this->escapeString('phonenumber');
  $verify = $this->Auth_model->checkEmailorPhone($phone);
  $token = $this->uniqueid();
  $hash_token = md5($token);
  if($verify)
  {
    $this->Auth_model->update_user_token($verify['phone'],$hash_token);
    $result = $this->Auth_model->checkEmailorPhone($phone);
    $to = $result['email'];
      $sub = 'Password Reset Instruction';
      $page_data['user_data'] = $result;
       $page_data['details'] = $result;
       $message = $this->load->view('Auth/Emails/password_reset_email',$page_data,TRUE);
       $this->send_mail($to,$sub,$message);
     $this->doResponse($status=true,$msg='Thank you for providing your account details. Further instruction has been sent to your registered email address',$title="",$data="");
            exit;
 }else{
      $this->doResponse($status=false,$msg='The details you supplied does not match any of our records',$title="",$data="");
   }
  
  }
  public function notifyAdmin_POST(){
     $token = $this->escapeString('token');
     $udetails = $this->authentication($token);
    $user_id = $udetails['accountid'];
     $amount_paid = $this->escapeString('amount');
    $invoice_number = $this->escapeString('reference');
    $bank = $this->escapeString('bankFrom');
    $sentTo = $this->escapeString('sentTo');
   if($_FILES['payment_proof']['name'] != "") {
    if ((($_FILES["payment_proof"]["type"] != "image/gif") || ($_FILES["payment_proof"]["type"]!= "image/jpeg") || ($_FILES["payment_proof"]["type"] != "image/jpg") || ($_FILES["payment_proof"]["type"] != "image/pjpeg") || ($_FILES["payment_proof"]["type"] != "image/x-png") || ($_FILES["payment_proof"]["type"] != "image/png")) && ($_FILES["payment_proof"]["size"] < 100000) && in_array($extension, $allowedExts)) {
    if ($_FILES["payment_proof"]["error"] > 0) {
        $error = $_FILES["payment_proof"]["error"];
      $this->doResponse($status=false,$msg=$error,$title="",$data="");
            exit;
     }
    }
   }
    $temp = explode(".", $_FILES["payment_proof"]["name"]);
    $newfilename = round(microtime(true)) . '.' . end($temp);
    $file_path = 'assets/images/payment_proof/'.$newfilename;
    move_uploaded_file($_FILES['payment_proof']['tmp_name'],'assets/uploads/payment_proof/'.$newfilename);
     $to = 'temmydev0@gmail.com';//get_settings('super_email');
    $account_name = $udetails['fullname'];
    $account_phone = $udetails['phone'];
    $account_email = $udetails['email'];
    $current_date = date('Y-m-d');
    $sub = 'Payment Notification of NGN '.$amount_paid.' From '.$account_name;
    $email_body = 'Hello Admin, <br/><br/> You have a pending payment notification as follows: <br/><br/> Sender Account : '.$account_name.'<br/><br/>Amount Paid: '.$amount_paid.' <br/><br/>Date:'.$current_date.' <br/><br/>Sender Phone Number: '.$account_phone.'<br/><br/>Bank Paid to: '.$bank.'<br/><br/>Transaction ID: '.$invoice_number;
    $send_notification = $this->send_mail($to,$sub,$email_body,$file_path);
    if($send_notification){
         $this->doResponse($status=true,$msg="Notification sent. Your wallet will be funded on confirmation of your transfer",$title="",$data="");
         exit;
       }else{
          $this->doResponse($status=false,$msg="Unable to send notification to admin now...Kindly try again later",$title="",$data="");
       exit;
    }
}
public function send_mail($to ='', $sub ='', $email_body='',$file_path=''){
  $this->load->library('phpmailer_lib');
  $from_name = get_settings('smtp_user');
  $app_name = get_settings('app_name');
  $mail = $this->phpmailer_lib->load();
  $host = get_settings('smtp_host');
  $port = get_settings('smtp_port');
  $user = get_settings('smtp_user');
  $pass = get_settings('smtp_pass');
  $mail->isSMTP();
  $mail->Host     = $host;
  $mail->SMTPAuth = true;
  $mail->Username = $user;
  $mail->Password = $pass;
  $mail->SMTPSecure = 'ssl';
  $mail->Port    = $port;
  $mail->setFrom($from_name, $app_name);
  $mail->addAddress($to);
  $mail->Subject = $sub;
  $mail->isHTML(true);
  $mailContent = $email_body;
  $mail->Body = $mailContent;
  if(!$mail->send()){
      return false;
  }else{
     return true;
   
  }
  
}
}